/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.Connection;
import com.oracle.bmc.dataconnectivity.model.DpEndpoint;
import com.oracle.bmc.dataconnectivity.model.ObjectMetadata;
import com.oracle.bmc.dataconnectivity.model.RegistryMetadata;
import com.oracle.bmc.dataconnectivity.model.TypeSystem;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataAssetSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="externalKey")
    private final String externalKey;
    @JsonProperty(value="assetProperties")
    private final Map<String, String> assetProperties;
    @JsonProperty(value="properties")
    private final Map<String, Object> properties;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="nativeTypeSystem")
    private final TypeSystem nativeTypeSystem;
    @JsonProperty(value="registryMetadata")
    private final RegistryMetadata registryMetadata;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonProperty(value="defaultConnection")
    private final Connection defaultConnection;
    @JsonProperty(value="endPoints")
    private final List<DpEndpoint> endPoints;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "modelType", "name", "description", "objectStatus", "objectVersion", "identifier", "externalKey", "assetProperties", "properties", "type", "nativeTypeSystem", "registryMetadata", "metadata", "defaultConnection", "endPoints"})
    public DataAssetSummary(String key, String modelVersion, String modelType, String name, String description, Integer objectStatus, Integer objectVersion, String identifier, String externalKey, Map<String, String> assetProperties, Map<String, Object> properties, String type, TypeSystem nativeTypeSystem, RegistryMetadata registryMetadata, ObjectMetadata metadata, Connection defaultConnection, List<DpEndpoint> endPoints) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.modelType = modelType;
        this.name = name;
        this.description = description;
        this.objectStatus = objectStatus;
        this.objectVersion = objectVersion;
        this.identifier = identifier;
        this.externalKey = externalKey;
        this.assetProperties = assetProperties;
        this.properties = properties;
        this.type = type;
        this.nativeTypeSystem = nativeTypeSystem;
        this.registryMetadata = registryMetadata;
        this.metadata = metadata;
        this.defaultConnection = defaultConnection;
        this.endPoints = endPoints;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public Map<String, String> getAssetProperties() {
        return this.assetProperties;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getType() {
        return this.type;
    }

    public TypeSystem getNativeTypeSystem() {
        return this.nativeTypeSystem;
    }

    public RegistryMetadata getRegistryMetadata() {
        return this.registryMetadata;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public Connection getDefaultConnection() {
        return this.defaultConnection;
    }

    public List<DpEndpoint> getEndPoints() {
        return this.endPoints;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataAssetSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", externalKey=").append(String.valueOf(this.externalKey));
        sb.append(", assetProperties=").append(String.valueOf(this.assetProperties));
        sb.append(", properties=").append(String.valueOf(this.properties));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", nativeTypeSystem=").append(String.valueOf((Object)this.nativeTypeSystem));
        sb.append(", registryMetadata=").append(String.valueOf((Object)this.registryMetadata));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(", defaultConnection=").append(String.valueOf((Object)this.defaultConnection));
        sb.append(", endPoints=").append(String.valueOf(this.endPoints));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataAssetSummary)) {
            return false;
        }
        DataAssetSummary other = (DataAssetSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.externalKey, other.externalKey) && Objects.equals(this.assetProperties, other.assetProperties) && Objects.equals(this.properties, other.properties) && Objects.equals(this.type, other.type) && Objects.equals((Object)this.nativeTypeSystem, (Object)other.nativeTypeSystem) && Objects.equals((Object)this.registryMetadata, (Object)other.registryMetadata) && Objects.equals((Object)this.metadata, (Object)other.metadata) && Objects.equals((Object)this.defaultConnection, (Object)other.defaultConnection) && Objects.equals(this.endPoints, other.endPoints) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.externalKey == null ? 43 : this.externalKey.hashCode());
        result = result * 59 + (this.assetProperties == null ? 43 : this.assetProperties.hashCode());
        result = result * 59 + (this.properties == null ? 43 : this.properties.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.nativeTypeSystem == null ? 43 : this.nativeTypeSystem.hashCode());
        result = result * 59 + (this.registryMetadata == null ? 43 : this.registryMetadata.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.defaultConnection == null ? 43 : this.defaultConnection.hashCode());
        result = result * 59 + (this.endPoints == null ? 43 : this.endPoints.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="externalKey")
        private String externalKey;
        @JsonProperty(value="assetProperties")
        private Map<String, String> assetProperties;
        @JsonProperty(value="properties")
        private Map<String, Object> properties;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="nativeTypeSystem")
        private TypeSystem nativeTypeSystem;
        @JsonProperty(value="registryMetadata")
        private RegistryMetadata registryMetadata;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="defaultConnection")
        private Connection defaultConnection;
        @JsonProperty(value="endPoints")
        private List<DpEndpoint> endPoints;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder externalKey(String externalKey) {
            this.externalKey = externalKey;
            this.__explicitlySet__.add("externalKey");
            return this;
        }

        public Builder assetProperties(Map<String, String> assetProperties) {
            this.assetProperties = assetProperties;
            this.__explicitlySet__.add("assetProperties");
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            this.__explicitlySet__.add("properties");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder nativeTypeSystem(TypeSystem nativeTypeSystem) {
            this.nativeTypeSystem = nativeTypeSystem;
            this.__explicitlySet__.add("nativeTypeSystem");
            return this;
        }

        public Builder registryMetadata(RegistryMetadata registryMetadata) {
            this.registryMetadata = registryMetadata;
            this.__explicitlySet__.add("registryMetadata");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder defaultConnection(Connection defaultConnection) {
            this.defaultConnection = defaultConnection;
            this.__explicitlySet__.add("defaultConnection");
            return this;
        }

        public Builder endPoints(List<DpEndpoint> endPoints) {
            this.endPoints = endPoints;
            this.__explicitlySet__.add("endPoints");
            return this;
        }

        public DataAssetSummary build() {
            DataAssetSummary model = new DataAssetSummary(this.key, this.modelVersion, this.modelType, this.name, this.description, this.objectStatus, this.objectVersion, this.identifier, this.externalKey, this.assetProperties, this.properties, this.type, this.nativeTypeSystem, this.registryMetadata, this.metadata, this.defaultConnection, this.endPoints);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataAssetSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("externalKey")) {
                this.externalKey(model.getExternalKey());
            }
            if (model.wasPropertyExplicitlySet("assetProperties")) {
                this.assetProperties(model.getAssetProperties());
            }
            if (model.wasPropertyExplicitlySet("properties")) {
                this.properties(model.getProperties());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("nativeTypeSystem")) {
                this.nativeTypeSystem(model.getNativeTypeSystem());
            }
            if (model.wasPropertyExplicitlySet("registryMetadata")) {
                this.registryMetadata(model.getRegistryMetadata());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("defaultConnection")) {
                this.defaultConnection(model.getDefaultConnection());
            }
            if (model.wasPropertyExplicitlySet("endPoints")) {
                this.endPoints(model.getEndPoints());
            }
            return this;
        }
    }
}

