/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Compression
extends ExplicitlySetBmcModel {
    @JsonProperty(value="codec")
    private final Codec codec;

    @Deprecated
    @ConstructorProperties(value={"codec"})
    public Compression(Codec codec) {
        this.codec = codec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Codec getCodec() {
        return this.codec;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Compression(");
        sb.append("super=").append(super.toString());
        sb.append("codec=").append(String.valueOf((Object)this.codec));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Compression)) {
            return false;
        }
        Compression other = (Compression)((Object)o);
        return Objects.equals((Object)this.codec, (Object)other.codec) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.codec == null ? 43 : this.codec.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Codec implements BmcEnum
    {
        None("NONE"),
        Auto("AUTO"),
        Gzip("GZIP"),
        Bzip2("BZIP2"),
        Deflate("DEFLATE"),
        Lz4("LZ4"),
        Snappy("SNAPPY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Codec> map;

        private Codec(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Codec create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Codec', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Codec.class);
            map = new HashMap<String, Codec>();
            for (Codec v : Codec.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="codec")
        private Codec codec;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder codec(Codec codec) {
            this.codec = codec;
            this.__explicitlySet__.add("codec");
            return this;
        }

        public Compression build() {
            Compression model = new Compression(this.codec);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Compression model) {
            if (model.wasPropertyExplicitlySet("codec")) {
                this.codec(model.getCodec());
            }
            return this;
        }
    }
}

