/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.BaseType;
import com.oracle.bmc.dataconnectivity.model.ConfigDefinition;
import com.oracle.bmc.dataconnectivity.model.ParentReference;
import com.oracle.bmc.dataconnectivity.model.TypedObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class CompositeType
extends BaseType {
    @JsonProperty(value="parentType")
    private final CompositeType parentType;
    @JsonProperty(value="elements")
    private final List<TypedObject> elements;
    @JsonProperty(value="configDefinition")
    private final ConfigDefinition configDefinition;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CompositeType(String key, String modelVersion, ParentReference parentRef, String name, Integer objectStatus, String description, CompositeType parentType, List<TypedObject> elements, ConfigDefinition configDefinition) {
        super(key, modelVersion, parentRef, name, objectStatus, description);
        this.parentType = parentType;
        this.elements = elements;
        this.configDefinition = configDefinition;
    }

    public CompositeType getParentType() {
        return this.parentType;
    }

    public List<TypedObject> getElements() {
        return this.elements;
    }

    public ConfigDefinition getConfigDefinition() {
        return this.configDefinition;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CompositeType(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", parentType=").append(String.valueOf((Object)this.parentType));
        sb.append(", elements=").append(String.valueOf(this.elements));
        sb.append(", configDefinition=").append(String.valueOf((Object)this.configDefinition));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeType)) {
            return false;
        }
        CompositeType other = (CompositeType)((Object)o);
        return Objects.equals((Object)this.parentType, (Object)other.parentType) && Objects.equals(this.elements, other.elements) && Objects.equals((Object)this.configDefinition, (Object)other.configDefinition) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.parentType == null ? 43 : this.parentType.hashCode());
        result = result * 59 + (this.elements == null ? 43 : this.elements.hashCode());
        result = result * 59 + (this.configDefinition == null ? 43 : this.configDefinition.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="parentType")
        private CompositeType parentType;
        @JsonProperty(value="elements")
        private List<TypedObject> elements;
        @JsonProperty(value="configDefinition")
        private ConfigDefinition configDefinition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder parentType(CompositeType parentType) {
            this.parentType = parentType;
            this.__explicitlySet__.add("parentType");
            return this;
        }

        public Builder elements(List<TypedObject> elements) {
            this.elements = elements;
            this.__explicitlySet__.add("elements");
            return this;
        }

        public Builder configDefinition(ConfigDefinition configDefinition) {
            this.configDefinition = configDefinition;
            this.__explicitlySet__.add("configDefinition");
            return this;
        }

        public CompositeType build() {
            CompositeType model = new CompositeType(this.key, this.modelVersion, this.parentRef, this.name, this.objectStatus, this.description, this.parentType, this.elements, this.configDefinition);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CompositeType model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("parentType")) {
                this.parentType(model.getParentType());
            }
            if (model.wasPropertyExplicitlySet("elements")) {
                this.elements(model.getElements());
            }
            if (model.wasPropertyExplicitlySet("configDefinition")) {
                this.configDefinition(model.getConfigDefinition());
            }
            return this;
        }
    }
}

