/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dataconnectivity.NetworkValidationAsync;
import com.oracle.bmc.dataconnectivity.model.NetworkConnectivityStatusCollection;
import com.oracle.bmc.dataconnectivity.requests.GetNetworkConnectivityStatusCollectionRequest;
import com.oracle.bmc.dataconnectivity.responses.GetNetworkConnectivityStatusCollectionResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkValidationAsyncClient
extends BaseAsyncClient
implements NetworkValidationAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NETWORKVALIDATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://dataconnectivity.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(NetworkValidationAsyncClient.class);

    private NetworkValidationAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetNetworkConnectivityStatusCollectionResponse> getNetworkConnectivityStatusCollection(GetNetworkConnectivityStatusCollectionRequest request, AsyncHandler<GetNetworkConnectivityStatusCollectionRequest, GetNetworkConnectivityStatusCollectionResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEndpointKey(), (String)"endpointKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetNetworkConnectivityStatusCollectionResponse::builder).logger(LOG, "getNetworkConnectivityStatusCollection").serviceDetails("NetworkValidation", "GetNetworkConnectivityStatusCollection", "").method(Method.GET).requestBuilder(GetNetworkConnectivityStatusCollectionRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("endpoints").appendPathParam(request.getEndpointKey()).appendPathParam("networkConnectivityStatusCollection").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(NetworkConnectivityStatusCollection.class, GetNetworkConnectivityStatusCollectionResponse.Builder::networkConnectivityStatusCollection).handleResponseHeaderString("opc-request-id", GetNetworkConnectivityStatusCollectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public NetworkValidationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)NetworkValidationAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkValidationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(NetworkValidationAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkValidationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)NetworkValidationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkValidationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)NetworkValidationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkValidationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)NetworkValidationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkValidationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)NetworkValidationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public NetworkValidationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)NetworkValidationAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NetworkValidationAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public NetworkValidationAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new NetworkValidationAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

