/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dataconnectivity.DataConnectivityManagementAsync;
import com.oracle.bmc.dataconnectivity.model.AttachDataAssetInfo;
import com.oracle.bmc.dataconnectivity.model.ConfigDetails;
import com.oracle.bmc.dataconnectivity.model.Connection;
import com.oracle.bmc.dataconnectivity.model.ConnectionSummaryCollection;
import com.oracle.bmc.dataconnectivity.model.ConnectionValidation;
import com.oracle.bmc.dataconnectivity.model.ConnectivityValidation;
import com.oracle.bmc.dataconnectivity.model.DataAsset;
import com.oracle.bmc.dataconnectivity.model.DataAssetSummaryCollection;
import com.oracle.bmc.dataconnectivity.model.DataEntity;
import com.oracle.bmc.dataconnectivity.model.DataEntitySummaryCollection;
import com.oracle.bmc.dataconnectivity.model.DataPreview;
import com.oracle.bmc.dataconnectivity.model.DataProfile;
import com.oracle.bmc.dataconnectivity.model.DeReferenceInfo;
import com.oracle.bmc.dataconnectivity.model.DeriveEntities;
import com.oracle.bmc.dataconnectivity.model.DetachDataAssetInfo;
import com.oracle.bmc.dataconnectivity.model.Endpoint;
import com.oracle.bmc.dataconnectivity.model.EndpointSummaryCollection;
import com.oracle.bmc.dataconnectivity.model.EntityShape;
import com.oracle.bmc.dataconnectivity.model.ExecuteOperationJob;
import com.oracle.bmc.dataconnectivity.model.ExecuteOperationJobDetails;
import com.oracle.bmc.dataconnectivity.model.Folder;
import com.oracle.bmc.dataconnectivity.model.FolderSummaryCollection;
import com.oracle.bmc.dataconnectivity.model.FullPushDownTaskResponse;
import com.oracle.bmc.dataconnectivity.model.NetworkConnectivityStatus;
import com.oracle.bmc.dataconnectivity.model.Operation;
import com.oracle.bmc.dataconnectivity.model.OperationSummaryCollection;
import com.oracle.bmc.dataconnectivity.model.ReferenceArtifactSummaryCollection;
import com.oracle.bmc.dataconnectivity.model.ReferenceInfo;
import com.oracle.bmc.dataconnectivity.model.Registry;
import com.oracle.bmc.dataconnectivity.model.RegistrySummaryCollection;
import com.oracle.bmc.dataconnectivity.model.Schema;
import com.oracle.bmc.dataconnectivity.model.SchemaSummaryCollection;
import com.oracle.bmc.dataconnectivity.model.TestNetworkConnectivity;
import com.oracle.bmc.dataconnectivity.model.Type;
import com.oracle.bmc.dataconnectivity.model.TypesSummaryCollection;
import com.oracle.bmc.dataconnectivity.model.WorkRequest;
import com.oracle.bmc.dataconnectivity.model.WorkRequestErrorCollection;
import com.oracle.bmc.dataconnectivity.model.WorkRequestLogCollection;
import com.oracle.bmc.dataconnectivity.model.WorkRequestSummaryCollection;
import com.oracle.bmc.dataconnectivity.requests.ChangeEndpointCompartmentRequest;
import com.oracle.bmc.dataconnectivity.requests.ChangeRegistryCompartmentRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateAttachDataAssetRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateConnectionRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateConnectionValidationRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateConnectivityValidationRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateDataAssetRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateDataPreviewRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateDataProfileRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateDeReferenceArtifactRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateDetachDataAssetRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateEndpointRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateEntityShapeRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateExecuteOperationJobRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateFolderRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateFullPushDownTaskRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateReferenceArtifactRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateRegistryRequest;
import com.oracle.bmc.dataconnectivity.requests.CreateTestNetworkConnectivityRequest;
import com.oracle.bmc.dataconnectivity.requests.DeleteConnectionRequest;
import com.oracle.bmc.dataconnectivity.requests.DeleteDataAssetRequest;
import com.oracle.bmc.dataconnectivity.requests.DeleteEndpointRequest;
import com.oracle.bmc.dataconnectivity.requests.DeleteFolderRequest;
import com.oracle.bmc.dataconnectivity.requests.DeleteNetworkConnectivityStatusRequest;
import com.oracle.bmc.dataconnectivity.requests.DeleteRegistryRequest;
import com.oracle.bmc.dataconnectivity.requests.DeriveEntitiesRequest;
import com.oracle.bmc.dataconnectivity.requests.GetConnectionRequest;
import com.oracle.bmc.dataconnectivity.requests.GetDataAssetRequest;
import com.oracle.bmc.dataconnectivity.requests.GetDataEntityRequest;
import com.oracle.bmc.dataconnectivity.requests.GetEndpointRequest;
import com.oracle.bmc.dataconnectivity.requests.GetEngineConfigurationsRequest;
import com.oracle.bmc.dataconnectivity.requests.GetExecuteOperationJobRequest;
import com.oracle.bmc.dataconnectivity.requests.GetFolderRequest;
import com.oracle.bmc.dataconnectivity.requests.GetNetworkConnectivityStatusRequest;
import com.oracle.bmc.dataconnectivity.requests.GetOperationRequest;
import com.oracle.bmc.dataconnectivity.requests.GetRegistryRequest;
import com.oracle.bmc.dataconnectivity.requests.GetSchemaRequest;
import com.oracle.bmc.dataconnectivity.requests.GetTypeRequest;
import com.oracle.bmc.dataconnectivity.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataconnectivity.requests.ListConnectionsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListDataAssetsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListDataEntitiesRequest;
import com.oracle.bmc.dataconnectivity.requests.ListEndpointsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListFoldersRequest;
import com.oracle.bmc.dataconnectivity.requests.ListOperationsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListReferenceArtifactsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListRegistriesRequest;
import com.oracle.bmc.dataconnectivity.requests.ListSchemasRequest;
import com.oracle.bmc.dataconnectivity.requests.ListTypesRequest;
import com.oracle.bmc.dataconnectivity.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataconnectivity.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataconnectivity.requests.UpdateConnectionRequest;
import com.oracle.bmc.dataconnectivity.requests.UpdateDataAssetRequest;
import com.oracle.bmc.dataconnectivity.requests.UpdateEndpointRequest;
import com.oracle.bmc.dataconnectivity.requests.UpdateFolderRequest;
import com.oracle.bmc.dataconnectivity.requests.UpdateRegistryRequest;
import com.oracle.bmc.dataconnectivity.requests.ValidateDataAssetNetworkReachablityRequest;
import com.oracle.bmc.dataconnectivity.responses.ChangeEndpointCompartmentResponse;
import com.oracle.bmc.dataconnectivity.responses.ChangeRegistryCompartmentResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateAttachDataAssetResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateConnectionResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateConnectionValidationResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateConnectivityValidationResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateDataAssetResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateDataPreviewResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateDataProfileResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateDeReferenceArtifactResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateDetachDataAssetResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateEndpointResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateEntityShapeResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateExecuteOperationJobResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateFolderResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateFullPushDownTaskResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateReferenceArtifactResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateRegistryResponse;
import com.oracle.bmc.dataconnectivity.responses.CreateTestNetworkConnectivityResponse;
import com.oracle.bmc.dataconnectivity.responses.DeleteConnectionResponse;
import com.oracle.bmc.dataconnectivity.responses.DeleteDataAssetResponse;
import com.oracle.bmc.dataconnectivity.responses.DeleteEndpointResponse;
import com.oracle.bmc.dataconnectivity.responses.DeleteFolderResponse;
import com.oracle.bmc.dataconnectivity.responses.DeleteNetworkConnectivityStatusResponse;
import com.oracle.bmc.dataconnectivity.responses.DeleteRegistryResponse;
import com.oracle.bmc.dataconnectivity.responses.DeriveEntitiesResponse;
import com.oracle.bmc.dataconnectivity.responses.GetConnectionResponse;
import com.oracle.bmc.dataconnectivity.responses.GetDataAssetResponse;
import com.oracle.bmc.dataconnectivity.responses.GetDataEntityResponse;
import com.oracle.bmc.dataconnectivity.responses.GetEndpointResponse;
import com.oracle.bmc.dataconnectivity.responses.GetEngineConfigurationsResponse;
import com.oracle.bmc.dataconnectivity.responses.GetExecuteOperationJobResponse;
import com.oracle.bmc.dataconnectivity.responses.GetFolderResponse;
import com.oracle.bmc.dataconnectivity.responses.GetNetworkConnectivityStatusResponse;
import com.oracle.bmc.dataconnectivity.responses.GetOperationResponse;
import com.oracle.bmc.dataconnectivity.responses.GetRegistryResponse;
import com.oracle.bmc.dataconnectivity.responses.GetSchemaResponse;
import com.oracle.bmc.dataconnectivity.responses.GetTypeResponse;
import com.oracle.bmc.dataconnectivity.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataconnectivity.responses.ListConnectionsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListDataAssetsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListDataEntitiesResponse;
import com.oracle.bmc.dataconnectivity.responses.ListEndpointsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListFoldersResponse;
import com.oracle.bmc.dataconnectivity.responses.ListOperationsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListReferenceArtifactsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListRegistriesResponse;
import com.oracle.bmc.dataconnectivity.responses.ListSchemasResponse;
import com.oracle.bmc.dataconnectivity.responses.ListTypesResponse;
import com.oracle.bmc.dataconnectivity.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataconnectivity.responses.ListWorkRequestsResponse;
import com.oracle.bmc.dataconnectivity.responses.UpdateConnectionResponse;
import com.oracle.bmc.dataconnectivity.responses.UpdateDataAssetResponse;
import com.oracle.bmc.dataconnectivity.responses.UpdateEndpointResponse;
import com.oracle.bmc.dataconnectivity.responses.UpdateFolderResponse;
import com.oracle.bmc.dataconnectivity.responses.UpdateRegistryResponse;
import com.oracle.bmc.dataconnectivity.responses.ValidateDataAssetNetworkReachablityResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConnectivityManagementAsyncClient
extends BaseAsyncClient
implements DataConnectivityManagementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATACONNECTIVITYMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://dataconnectivity.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DataConnectivityManagementAsyncClient.class);

    private DataConnectivityManagementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeEndpointCompartmentResponse> changeEndpointCompartment(ChangeEndpointCompartmentRequest request, AsyncHandler<ChangeEndpointCompartmentRequest, ChangeEndpointCompartmentResponse> handler) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeEndpointCompartmentDetails(), "changeEndpointCompartmentDetails is required");
        return this.clientCall(request, ChangeEndpointCompartmentResponse::builder).logger(LOG, "changeEndpointCompartment").serviceDetails("DataConnectivityManagement", "ChangeEndpointCompartment", "").method(Method.POST).requestBuilder(ChangeEndpointCompartmentRequest::builder).basePath("/20210217").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").appendQueryParam("registryId", (Object)request.getRegistryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeEndpointCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeEndpointCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeRegistryCompartmentResponse> changeRegistryCompartment(ChangeRegistryCompartmentRequest request, AsyncHandler<ChangeRegistryCompartmentRequest, ChangeRegistryCompartmentResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRegistryCompartmentDetails(), "changeRegistryCompartmentDetails is required");
        return this.clientCall(request, ChangeRegistryCompartmentResponse::builder).logger(LOG, "changeRegistryCompartment").serviceDetails("DataConnectivityManagement", "ChangeRegistryCompartment", "").method(Method.POST).requestBuilder(ChangeRegistryCompartmentRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeRegistryCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeRegistryCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAttachDataAssetResponse> createAttachDataAsset(CreateAttachDataAssetRequest request, AsyncHandler<CreateAttachDataAssetRequest, CreateAttachDataAssetResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateAttachDataAssetDetails(), "createAttachDataAssetDetails is required");
        return this.clientCall(request, CreateAttachDataAssetResponse::builder).logger(LOG, "createAttachDataAsset").serviceDetails("DataConnectivityManagement", "CreateAttachDataAsset", "").method(Method.POST).requestBuilder(CreateAttachDataAssetRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("endpoints").appendPathParam(request.getEndpointId()).appendPathParam("actions").appendPathParam("attachDataAssets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(AttachDataAssetInfo.class, CreateAttachDataAssetResponse.Builder::attachDataAssetInfo).handleResponseHeaderString("opc-request-id", CreateAttachDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateConnectionResponse> createConnection(CreateConnectionRequest request, AsyncHandler<CreateConnectionRequest, CreateConnectionResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateConnectionDetails(), "createConnectionDetails is required");
        return this.clientCall(request, CreateConnectionResponse::builder).logger(LOG, "createConnection").serviceDetails("DataConnectivityManagement", "CreateConnection", "").method(Method.POST).requestBuilder(CreateConnectionRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Connection.class, CreateConnectionResponse.Builder::connection).handleResponseHeaderString("etag", CreateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateConnectionValidationResponse> createConnectionValidation(CreateConnectionValidationRequest request, AsyncHandler<CreateConnectionValidationRequest, CreateConnectionValidationResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateConnectionValidationDetails(), "createConnectionValidationDetails is required");
        return this.clientCall(request, CreateConnectionValidationResponse::builder).logger(LOG, "createConnectionValidation").serviceDetails("DataConnectivityManagement", "CreateConnectionValidation", "").method(Method.POST).requestBuilder(CreateConnectionValidationRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connectionValidations").appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ConnectionValidation.class, CreateConnectionValidationResponse.Builder::connectionValidation).handleResponseHeaderString("etag", CreateConnectionValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateConnectionValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateConnectivityValidationResponse> createConnectivityValidation(CreateConnectivityValidationRequest request, AsyncHandler<CreateConnectivityValidationRequest, CreateConnectivityValidationResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateConnectivityValidationDetails(), "createConnectivityValidationDetails is required");
        return this.clientCall(request, CreateConnectivityValidationResponse::builder).logger(LOG, "createConnectivityValidation").serviceDetails("DataConnectivityManagement", "CreateConnectivityValidation", "").method(Method.POST).requestBuilder(CreateConnectivityValidationRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("actions").appendPathParam("connectivityValidation").appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ConnectivityValidation.class, CreateConnectivityValidationResponse.Builder::connectivityValidation).handleResponseHeaderString("etag", CreateConnectivityValidationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateConnectivityValidationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDataAssetResponse> createDataAsset(CreateDataAssetRequest request, AsyncHandler<CreateDataAssetRequest, CreateDataAssetResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDataAssetDetails(), "createDataAssetDetails is required");
        return this.clientCall(request, CreateDataAssetResponse::builder).logger(LOG, "createDataAsset").serviceDetails("DataConnectivityManagement", "CreateDataAsset", "").method(Method.POST).requestBuilder(CreateDataAssetRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("dataAssets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DataAsset.class, CreateDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", CreateDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDataPreviewResponse> createDataPreview(CreateDataPreviewRequest request, AsyncHandler<CreateDataPreviewRequest, CreateDataPreviewResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDataPreviewDetails(), "createDataPreviewDetails is required");
        return this.clientCall(request, CreateDataPreviewResponse::builder).logger(LOG, "createDataPreview").serviceDetails("DataConnectivityManagement", "CreateDataPreview", "").method(Method.POST).requestBuilder(CreateDataPreviewRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("actions").appendPathParam("dataPreview").appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DataPreview.class, CreateDataPreviewResponse.Builder::dataPreview).handleResponseHeaderString("opc-request-id", CreateDataPreviewResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDataProfileResponse> createDataProfile(CreateDataProfileRequest request, AsyncHandler<CreateDataProfileRequest, CreateDataProfileResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDataProfileDetails(), "createDataProfileDetails is required");
        return this.clientCall(request, CreateDataProfileResponse::builder).logger(LOG, "createDataProfile").serviceDetails("DataConnectivityManagement", "CreateDataProfile", "").method(Method.POST).requestBuilder(CreateDataProfileRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("actions").appendPathParam("dataProfile").appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DataProfile.class, CreateDataProfileResponse.Builder::dataProfile).handleResponseHeaderString("opc-request-id", CreateDataProfileResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDeReferenceArtifactResponse> createDeReferenceArtifact(CreateDeReferenceArtifactRequest request, AsyncHandler<CreateDeReferenceArtifactRequest, CreateDeReferenceArtifactResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDcmsArtifactId(), (String)"dcmsArtifactId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDeReferenceArtifactDetails(), "createDeReferenceArtifactDetails is required");
        return this.clientCall(request, CreateDeReferenceArtifactResponse::builder).logger(LOG, "createDeReferenceArtifact").serviceDetails("DataConnectivityManagement", "CreateDeReferenceArtifact", "").method(Method.POST).requestBuilder(CreateDeReferenceArtifactRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("dcmsArtifacts").appendPathParam(request.getDcmsArtifactId()).appendPathParam("actions").appendPathParam("deReferenceArtifact").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DeReferenceInfo.class, CreateDeReferenceArtifactResponse.Builder::deReferenceInfo).handleResponseHeaderString("etag", CreateDeReferenceArtifactResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDeReferenceArtifactResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDetachDataAssetResponse> createDetachDataAsset(CreateDetachDataAssetRequest request, AsyncHandler<CreateDetachDataAssetRequest, CreateDetachDataAssetResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDetachDataAssetDetails(), "createDetachDataAssetDetails is required");
        return this.clientCall(request, CreateDetachDataAssetResponse::builder).logger(LOG, "createDetachDataAsset").serviceDetails("DataConnectivityManagement", "CreateDetachDataAsset", "").method(Method.POST).requestBuilder(CreateDetachDataAssetRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("endpoints").appendPathParam(request.getEndpointId()).appendPathParam("actions").appendPathParam("detachDataAssets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DetachDataAssetInfo.class, CreateDetachDataAssetResponse.Builder::detachDataAssetInfo).handleResponseHeaderString("opc-request-id", CreateDetachDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateEndpointResponse> createEndpoint(CreateEndpointRequest request, AsyncHandler<CreateEndpointRequest, CreateEndpointResponse> handler) {
        Objects.requireNonNull(request.getCreateEndpointDetails(), "createEndpointDetails is required");
        return this.clientCall(request, CreateEndpointResponse::builder).logger(LOG, "createEndpoint").serviceDetails("DataConnectivityManagement", "CreateEndpoint", "").method(Method.POST).requestBuilder(CreateEndpointRequest::builder).basePath("/20210217").appendPathParam("endpoints").appendQueryParam("registryId", (Object)request.getRegistryId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", CreateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateEndpointResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateEntityShapeResponse> createEntityShape(CreateEntityShapeRequest request, AsyncHandler<CreateEntityShapeRequest, CreateEntityShapeResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateEntityShapeDetails(), "createEntityShapeDetails is required");
        return this.clientCall(request, CreateEntityShapeResponse::builder).logger(LOG, "createEntityShape").serviceDetails("DataConnectivityManagement", "CreateEntityShape", "").method(Method.POST).requestBuilder(CreateEntityShapeRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).appendPathParam("actions").appendPathParam("entityShapes").appendEnumQueryParam("authorizationMode", (BmcEnum)request.getAuthorizationMode()).appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(EntityShape.class, CreateEntityShapeResponse.Builder::entityShape).handleResponseHeaderString("opc-request-id", CreateEntityShapeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateExecuteOperationJobResponse> createExecuteOperationJob(CreateExecuteOperationJobRequest request, AsyncHandler<CreateExecuteOperationJobRequest, CreateExecuteOperationJobResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateExecuteOperationJobDetails(), "createExecuteOperationJobDetails is required");
        return this.clientCall(request, CreateExecuteOperationJobResponse::builder).logger(LOG, "createExecuteOperationJob").serviceDetails("DataConnectivityManagement", "CreateExecuteOperationJob", "").method(Method.POST).requestBuilder(CreateExecuteOperationJobRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).appendPathParam("actions").appendPathParam("executeOperationJobs").appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ExecuteOperationJobDetails.class, CreateExecuteOperationJobResponse.Builder::executeOperationJobDetails).handleResponseHeaderString("etag", CreateExecuteOperationJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateExecuteOperationJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFolderResponse> createFolder(CreateFolderRequest request, AsyncHandler<CreateFolderRequest, CreateFolderResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateFolderDetails(), "createFolderDetails is required");
        return this.clientCall(request, CreateFolderResponse::builder).logger(LOG, "createFolder").serviceDetails("DataConnectivityManagement", "CreateFolder", "").method(Method.POST).requestBuilder(CreateFolderRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("folders").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Folder.class, CreateFolderResponse.Builder::folder).handleResponseHeaderString("etag", CreateFolderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateFolderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFullPushDownTaskResponse> createFullPushDownTask(CreateFullPushDownTaskRequest request, AsyncHandler<CreateFullPushDownTaskRequest, CreateFullPushDownTaskResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateFullPushDownTaskDetails(), "createFullPushDownTaskDetails is required");
        return this.clientCall(request, CreateFullPushDownTaskResponse::builder).logger(LOG, "createFullPushDownTask").serviceDetails("DataConnectivityManagement", "CreateFullPushDownTask", "").method(Method.POST).requestBuilder(CreateFullPushDownTaskRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("actions").appendPathParam("fullPushDownTask").appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(FullPushDownTaskResponse.class, CreateFullPushDownTaskResponse.Builder::fullPushDownTaskResponse).handleResponseHeaderString("etag", CreateFullPushDownTaskResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateFullPushDownTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateReferenceArtifactResponse> createReferenceArtifact(CreateReferenceArtifactRequest request, AsyncHandler<CreateReferenceArtifactRequest, CreateReferenceArtifactResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDcmsArtifactId(), (String)"dcmsArtifactId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateReferenceArtifactDetails(), "createReferenceArtifactDetails is required");
        return this.clientCall(request, CreateReferenceArtifactResponse::builder).logger(LOG, "createReferenceArtifact").serviceDetails("DataConnectivityManagement", "CreateReferenceArtifact", "").method(Method.POST).requestBuilder(CreateReferenceArtifactRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("dcmsArtifacts").appendPathParam(request.getDcmsArtifactId()).appendPathParam("actions").appendPathParam("referenceArtifact").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ReferenceInfo.class, CreateReferenceArtifactResponse.Builder::referenceInfo).handleResponseHeaderString("etag", CreateReferenceArtifactResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateReferenceArtifactResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateRegistryResponse> createRegistry(CreateRegistryRequest request, AsyncHandler<CreateRegistryRequest, CreateRegistryResponse> handler) {
        Objects.requireNonNull(request.getCreateRegistryDetails(), "createRegistryDetails is required");
        return this.clientCall(request, CreateRegistryResponse::builder).logger(LOG, "createRegistry").serviceDetails("DataConnectivityManagement", "CreateRegistry", "").method(Method.POST).requestBuilder(CreateRegistryRequest::builder).basePath("/20210217").appendPathParam("registries").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", CreateRegistryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateRegistryResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateTestNetworkConnectivityResponse> createTestNetworkConnectivity(CreateTestNetworkConnectivityRequest request, AsyncHandler<CreateTestNetworkConnectivityRequest, CreateTestNetworkConnectivityResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTestNetworkConnectivityDetails(), "createTestNetworkConnectivityDetails is required");
        return this.clientCall(request, CreateTestNetworkConnectivityResponse::builder).logger(LOG, "createTestNetworkConnectivity").serviceDetails("DataConnectivityManagement", "CreateTestNetworkConnectivity", "").method(Method.POST).requestBuilder(CreateTestNetworkConnectivityRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("actions").appendPathParam("testNetworkConnectivity").appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(TestNetworkConnectivity.class, CreateTestNetworkConnectivityResponse.Builder::testNetworkConnectivity).handleResponseHeaderString("etag", CreateTestNetworkConnectivityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTestNetworkConnectivityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest request, AsyncHandler<DeleteConnectionRequest, DeleteConnectionResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteConnectionResponse::builder).logger(LOG, "deleteConnection").serviceDetails("DataConnectivityManagement", "DeleteConnection", "").method(Method.DELETE).requestBuilder(DeleteConnectionRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDataAssetResponse> deleteDataAsset(DeleteDataAssetRequest request, AsyncHandler<DeleteDataAssetRequest, DeleteDataAssetResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDataAssetResponse::builder).logger(LOG, "deleteDataAsset").serviceDetails("DataConnectivityManagement", "DeleteDataAsset", "").method(Method.DELETE).requestBuilder(DeleteDataAssetRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest request, AsyncHandler<DeleteEndpointRequest, DeleteEndpointResponse> handler) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteEndpointResponse::builder).logger(LOG, "deleteEndpoint").serviceDetails("DataConnectivityManagement", "DeleteEndpoint", "").method(Method.DELETE).requestBuilder(DeleteEndpointRequest::builder).basePath("/20210217").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).appendQueryParam("registryId", (Object)request.getRegistryId()).appendQueryParam("isForceOperation", (Object)request.getIsForceOperation()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteEndpointResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFolderResponse> deleteFolder(DeleteFolderRequest request, AsyncHandler<DeleteFolderRequest, DeleteFolderResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFolderResponse::builder).logger(LOG, "deleteFolder").serviceDetails("DataConnectivityManagement", "DeleteFolder", "").method(Method.DELETE).requestBuilder(DeleteFolderRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("folders").appendPathParam(request.getFolderKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteFolderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteNetworkConnectivityStatusResponse> deleteNetworkConnectivityStatus(DeleteNetworkConnectivityStatusRequest request, AsyncHandler<DeleteNetworkConnectivityStatusRequest, DeleteNetworkConnectivityStatusResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNetworkValidationStatusKey(), (String)"networkValidationStatusKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteNetworkConnectivityStatusResponse::builder).logger(LOG, "deleteNetworkConnectivityStatus").serviceDetails("DataConnectivityManagement", "DeleteNetworkConnectivityStatus", "").method(Method.DELETE).requestBuilder(DeleteNetworkConnectivityStatusRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("networkConnectivityStatus").appendPathParam(request.getNetworkValidationStatusKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteNetworkConnectivityStatusResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRegistryResponse> deleteRegistry(DeleteRegistryRequest request, AsyncHandler<DeleteRegistryRequest, DeleteRegistryResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRegistryResponse::builder).logger(LOG, "deleteRegistry").serviceDetails("DataConnectivityManagement", "DeleteRegistry", "").method(Method.DELETE).requestBuilder(DeleteRegistryRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendQueryParam("isForceOperation", (Object)request.getIsForceOperation()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteRegistryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteRegistryResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeriveEntitiesResponse> deriveEntities(DeriveEntitiesRequest request, AsyncHandler<DeriveEntitiesRequest, DeriveEntitiesResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDeriveEntitiesDetails(), "deriveEntitiesDetails is required");
        return this.clientCall(request, DeriveEntitiesResponse::builder).logger(LOG, "deriveEntities").serviceDetails("DataConnectivityManagement", "DeriveEntities", "").method(Method.POST).requestBuilder(DeriveEntitiesRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("actions").appendPathParam("deriveEntities").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DeriveEntities.class, DeriveEntitiesResponse.Builder::deriveEntities).handleResponseHeaderString("opc-request-id", DeriveEntitiesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConnectionResponse> getConnection(GetConnectionRequest request, AsyncHandler<GetConnectionRequest, GetConnectionResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConnectionResponse::builder).logger(LOG, "getConnection").serviceDetails("DataConnectivityManagement", "GetConnection", "").method(Method.GET).requestBuilder(GetConnectionRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Connection.class, GetConnectionResponse.Builder::connection).handleResponseHeaderString("etag", GetConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDataAssetResponse> getDataAsset(GetDataAssetRequest request, AsyncHandler<GetDataAssetRequest, GetDataAssetResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDataAssetResponse::builder).logger(LOG, "getDataAsset").serviceDetails("DataConnectivityManagement", "GetDataAsset", "").method(Method.GET).requestBuilder(GetDataAssetRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataAsset.class, GetDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", GetDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDataEntityResponse> getDataEntity(GetDataEntityRequest request, AsyncHandler<GetDataEntityRequest, GetDataEntityResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataEntityKey(), (String)"dataEntityKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDataEntityResponse::builder).logger(LOG, "getDataEntity").serviceDetails("DataConnectivityManagement", "GetDataEntity", "").method(Method.GET).requestBuilder(GetDataEntityRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).appendPathParam("dataEntities").appendPathParam(request.getDataEntityKey()).appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataEntity.class, GetDataEntityResponse.Builder::dataEntity).handleResponseHeaderString("opc-request-id", GetDataEntityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetEndpointResponse> getEndpoint(GetEndpointRequest request, AsyncHandler<GetEndpointRequest, GetEndpointResponse> handler) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetEndpointResponse::builder).logger(LOG, "getEndpoint").serviceDetails("DataConnectivityManagement", "GetEndpoint", "").method(Method.GET).requestBuilder(GetEndpointRequest::builder).basePath("/20210217").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).appendQueryParam("registryId", (Object)request.getRegistryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Endpoint.class, GetEndpointResponse.Builder::endpoint).handleResponseHeaderString("etag", GetEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetEngineConfigurationsResponse> getEngineConfigurations(GetEngineConfigurationsRequest request, AsyncHandler<GetEngineConfigurationsRequest, GetEngineConfigurationsResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetEngineConfigurationsResponse::builder).logger(LOG, "getEngineConfigurations").serviceDetails("DataConnectivityManagement", "GetEngineConfigurations", "").method(Method.GET).requestBuilder(GetEngineConfigurationsRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("engineConfigurations").appendEnumQueryParam("engineTypeQueryParam", (BmcEnum)request.getEngineTypeQueryParam()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConfigDetails.class, GetEngineConfigurationsResponse.Builder::configDetails).handleResponseHeaderString("opc-request-id", GetEngineConfigurationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExecuteOperationJobResponse> getExecuteOperationJob(GetExecuteOperationJobRequest request, AsyncHandler<GetExecuteOperationJobRequest, GetExecuteOperationJobResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExecuteOperationJobKey(), (String)"executeOperationJobKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExecuteOperationJobResponse::builder).logger(LOG, "getExecuteOperationJob").serviceDetails("DataConnectivityManagement", "GetExecuteOperationJob", "").method(Method.GET).requestBuilder(GetExecuteOperationJobRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).appendPathParam("executeOperationJobs").appendPathParam(request.getExecuteOperationJobKey()).appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExecuteOperationJob.class, GetExecuteOperationJobResponse.Builder::executeOperationJob).handleResponseHeaderString("opc-request-id", GetExecuteOperationJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFolderResponse> getFolder(GetFolderRequest request, AsyncHandler<GetFolderRequest, GetFolderResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFolderResponse::builder).logger(LOG, "getFolder").serviceDetails("DataConnectivityManagement", "GetFolder", "").method(Method.GET).requestBuilder(GetFolderRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("folders").appendPathParam(request.getFolderKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Folder.class, GetFolderResponse.Builder::folder).handleResponseHeaderString("etag", GetFolderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFolderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetNetworkConnectivityStatusResponse> getNetworkConnectivityStatus(GetNetworkConnectivityStatusRequest request, AsyncHandler<GetNetworkConnectivityStatusRequest, GetNetworkConnectivityStatusResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetNetworkConnectivityStatusResponse::builder).logger(LOG, "getNetworkConnectivityStatus").serviceDetails("DataConnectivityManagement", "GetNetworkConnectivityStatus", "").method(Method.GET).requestBuilder(GetNetworkConnectivityStatusRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("networkConnectivityStatus").appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleBody(NetworkConnectivityStatus.class, GetNetworkConnectivityStatusResponse.Builder::networkConnectivityStatus).handleResponseHeaderString("etag", GetNetworkConnectivityStatusResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNetworkConnectivityStatusResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOperationResponse> getOperation(GetOperationRequest request, AsyncHandler<GetOperationRequest, GetOperationResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOperationResourceName(), (String)"operationResourceName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOperationResponse::builder).logger(LOG, "getOperation").serviceDetails("DataConnectivityManagement", "GetOperation", "").method(Method.GET).requestBuilder(GetOperationRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).appendPathParam("operations").appendPathParam(request.getOperationResourceName()).appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Operation.class, GetOperationResponse.Builder::operation).handleResponseHeaderString("opc-request-id", GetOperationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRegistryResponse> getRegistry(GetRegistryRequest request, AsyncHandler<GetRegistryRequest, GetRegistryResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRegistryResponse::builder).logger(LOG, "getRegistry").serviceDetails("DataConnectivityManagement", "GetRegistry", "").method(Method.GET).requestBuilder(GetRegistryRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Registry.class, GetRegistryResponse.Builder::registry).handleResponseHeaderString("etag", GetRegistryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRegistryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSchemaResponse> getSchema(GetSchemaRequest request, AsyncHandler<GetSchemaRequest, GetSchemaResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSchemaResponse::builder).logger(LOG, "getSchema").serviceDetails("DataConnectivityManagement", "GetSchema", "").method(Method.GET).requestBuilder(GetSchemaRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Schema.class, GetSchemaResponse.Builder::schema).handleResponseHeaderString("opc-request-id", GetSchemaResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTypeResponse> getType(GetTypeRequest request, AsyncHandler<GetTypeRequest, GetTypeResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTypeKey(), (String)"typeKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTypeResponse::builder).logger(LOG, "getType").serviceDetails("DataConnectivityManagement", "GetType", "").method(Method.GET).requestBuilder(GetTypeRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("types").appendPathParam(request.getTypeKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Type.class, GetTypeResponse.Builder::type).handleResponseHeaderString("etag", GetTypeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTypeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DataConnectivityManagement", "GetWorkRequest", "").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210217").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListConnectionsResponse> listConnections(ListConnectionsRequest request, AsyncHandler<ListConnectionsRequest, ListConnectionsResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDataAssetKey(), "dataAssetKey is required");
        return this.clientCall(request, ListConnectionsResponse::builder).logger(LOG, "listConnections").serviceDetails("DataConnectivityManagement", "ListConnections", "").method(Method.GET).requestBuilder(ListConnectionsRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendQueryParam("dataAssetKey", (Object)request.getDataAssetKey()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("type", (Object)request.getType()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("favoritesQueryParam", (BmcEnum)request.getFavoritesQueryParam()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectionSummaryCollection.class, ListConnectionsResponse.Builder::connectionSummaryCollection).handleResponseHeaderString("opc-request-id", ListConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListConnectionsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListConnectionsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListDataAssetsResponse> listDataAssets(ListDataAssetsRequest request, AsyncHandler<ListDataAssetsRequest, ListDataAssetsResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDataAssetsResponse::builder).logger(LOG, "listDataAssets").serviceDetails("DataConnectivityManagement", "ListDataAssets", "").method(Method.GET).requestBuilder(ListDataAssetsRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("dataAssets").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendListQueryParam("includeTypes", request.getIncludeTypes(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("excludeTypes", request.getExcludeTypes(), CollectionFormatType.Multi).appendEnumQueryParam("favoritesQueryParam", (BmcEnum)request.getFavoritesQueryParam()).appendQueryParam("folderId", (Object)request.getFolderId()).appendListQueryParam("endpointIds", request.getEndpointIds(), CollectionFormatType.Multi).appendListQueryParam("excludeEndpointIds", request.getExcludeEndpointIds(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataAssetSummaryCollection.class, ListDataAssetsResponse.Builder::dataAssetSummaryCollection).handleResponseHeaderString("opc-request-id", ListDataAssetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataAssetsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListDataAssetsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListDataAssetsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListDataEntitiesResponse> listDataEntities(ListDataEntitiesRequest request, AsyncHandler<ListDataEntitiesRequest, ListDataEntitiesResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDataEntitiesResponse::builder).logger(LOG, "listDataEntities").serviceDetails("DataConnectivityManagement", "ListDataEntities", "").method(Method.GET).requestBuilder(ListDataEntitiesRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).appendPathParam("dataEntities").appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("type", (Object)request.getType()).appendQueryParam("limit", (Object)request.getLimit()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("apiMode", (BmcEnum)request.getApiMode()).appendListQueryParam("nameList", request.getNameList(), CollectionFormatType.Multi).appendQueryParam("isPattern", (Object)request.getIsPattern()).appendQueryParam("endpointId", (Object)request.getEndpointId()).appendListQueryParam("includeTypes", request.getIncludeTypes(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataEntitySummaryCollection.class, ListDataEntitiesResponse.Builder::dataEntitySummaryCollection).handleResponseHeaderString("opc-request-id", ListDataEntitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataEntitiesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListDataEntitiesResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListDataEntitiesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListEndpointsResponse> listEndpoints(ListEndpointsRequest request, AsyncHandler<ListEndpointsRequest, ListEndpointsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListEndpointsResponse::builder).logger(LOG, "listEndpoints").serviceDetails("DataConnectivityManagement", "ListEndpoints", "").method(Method.GET).requestBuilder(ListEndpointsRequest::builder).basePath("/20210217").appendPathParam("endpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("registryId", (Object)request.getRegistryId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EndpointSummaryCollection.class, ListEndpointsResponse.Builder::endpointSummaryCollection).handleResponseHeaderString("opc-request-id", ListEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEndpointsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFoldersResponse> listFolders(ListFoldersRequest request, AsyncHandler<ListFoldersRequest, ListFoldersResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListFoldersResponse::builder).logger(LOG, "listFolders").serviceDetails("DataConnectivityManagement", "ListFolders", "").method(Method.GET).requestBuilder(ListFoldersRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("folders").appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("type", (Object)request.getType()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("favoritesQueryParam", (BmcEnum)request.getFavoritesQueryParam()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FolderSummaryCollection.class, ListFoldersResponse.Builder::folderSummaryCollection).handleResponseHeaderString("opc-request-id", ListFoldersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFoldersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListFoldersResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListFoldersResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListOperationsResponse> listOperations(ListOperationsRequest request, AsyncHandler<ListOperationsRequest, ListOperationsResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSchemaResourceName(), (String)"schemaResourceName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListOperationsResponse::builder).logger(LOG, "listOperations").serviceDetails("DataConnectivityManagement", "ListOperations", "").method(Method.GET).requestBuilder(ListOperationsRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendPathParam(request.getSchemaResourceName()).appendPathParam("operations").appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("endpointId", (Object)request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OperationSummaryCollection.class, ListOperationsResponse.Builder::operationSummaryCollection).handleResponseHeaderString("opc-request-id", ListOperationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOperationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListOperationsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListOperationsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListReferenceArtifactsResponse> listReferenceArtifacts(ListReferenceArtifactsRequest request, AsyncHandler<ListReferenceArtifactsRequest, ListReferenceArtifactsResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDcmsArtifactId(), (String)"dcmsArtifactId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListReferenceArtifactsResponse::builder).logger(LOG, "listReferenceArtifacts").serviceDetails("DataConnectivityManagement", "ListReferenceArtifacts", "").method(Method.GET).requestBuilder(ListReferenceArtifactsRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("dcmsArtifacts").appendPathParam(request.getDcmsArtifactId()).appendPathParam("referenceArtifacts").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("type", (Object)request.getType()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("excludeTypes", request.getExcludeTypes(), CollectionFormatType.Multi).appendEnumQueryParam("favoritesQueryParam", (BmcEnum)request.getFavoritesQueryParam()).appendQueryParam("serviceArtifactId", (Object)request.getServiceArtifactId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ReferenceArtifactSummaryCollection.class, ListReferenceArtifactsResponse.Builder::referenceArtifactSummaryCollection).handleResponseHeaderString("opc-request-id", ListReferenceArtifactsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListReferenceArtifactsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListReferenceArtifactsResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListReferenceArtifactsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListRegistriesResponse> listRegistries(ListRegistriesRequest request, AsyncHandler<ListRegistriesRequest, ListRegistriesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListRegistriesResponse::builder).logger(LOG, "listRegistries").serviceDetails("DataConnectivityManagement", "ListRegistries", "").method(Method.GET).requestBuilder(ListRegistriesRequest::builder).basePath("/20210217").appendPathParam("registries").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("isDeepLookup", (Object)request.getIsDeepLookup()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RegistrySummaryCollection.class, ListRegistriesResponse.Builder::registrySummaryCollection).handleResponseHeaderString("opc-request-id", ListRegistriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRegistriesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSchemasResponse> listSchemas(ListSchemasRequest request, AsyncHandler<ListSchemasRequest, ListSchemasResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSchemasResponse::builder).logger(LOG, "listSchemas").serviceDetails("DataConnectivityManagement", "ListSchemas", "").method(Method.GET).requestBuilder(ListSchemasRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("schemas").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("schemaResourceKey", (Object)request.getSchemaResourceKey()).appendQueryParam("name", (Object)request.getName()).appendListQueryParam("nameList", request.getNameList(), CollectionFormatType.Multi).appendQueryParam("endpointId", (Object)request.getEndpointId()).appendListQueryParam("includeTypes", request.getIncludeTypes(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SchemaSummaryCollection.class, ListSchemasResponse.Builder::schemaSummaryCollection).handleResponseHeaderString("opc-request-id", ListSchemasResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSchemasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListSchemasResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListSchemasResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListTypesResponse> listTypes(ListTypesRequest request, AsyncHandler<ListTypesRequest, ListTypesResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTypesResponse::builder).logger(LOG, "listTypes").serviceDetails("DataConnectivityManagement", "ListTypes", "").method(Method.GET).requestBuilder(ListTypesRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("types").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("type", (Object)request.getType()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TypesSummaryCollection.class, ListTypesResponse.Builder::typesSummaryCollection).handleResponseHeaderString("opc-request-id", ListTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTypesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListTypesResponse.Builder::opcPrevPage).handleResponseHeaderInteger("opc-total-items", ListTypesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DataConnectivityManagement", "ListWorkRequestErrors", "").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210217").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("workRequestErrors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DataConnectivityManagement", "ListWorkRequestLogs", "").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210217").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DataConnectivityManagement", "ListWorkRequests", "").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210217").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("registryId", (Object)request.getRegistryId()).appendEnumQueryParam("workRequestStatus", (BmcEnum)request.getWorkRequestStatus()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest request, AsyncHandler<UpdateConnectionRequest, UpdateConnectionResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConnectionDetails(), "updateConnectionDetails is required");
        return this.clientCall(request, UpdateConnectionResponse::builder).logger(LOG, "updateConnection").serviceDetails("DataConnectivityManagement", "UpdateConnection", "").method(Method.PUT).requestBuilder(UpdateConnectionRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Connection.class, UpdateConnectionResponse.Builder::connection).handleResponseHeaderString("etag", UpdateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDataAssetResponse> updateDataAsset(UpdateDataAssetRequest request, AsyncHandler<UpdateDataAssetRequest, UpdateDataAssetResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDataAssetDetails(), "updateDataAssetDetails is required");
        return this.clientCall(request, UpdateDataAssetResponse::builder).logger(LOG, "updateDataAsset").serviceDetails("DataConnectivityManagement", "UpdateDataAsset", "").method(Method.PUT).requestBuilder(UpdateDataAssetRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DataAsset.class, UpdateDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", UpdateDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest request, AsyncHandler<UpdateEndpointRequest, UpdateEndpointResponse> handler) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEndpointDetails(), "updateEndpointDetails is required");
        return this.clientCall(request, UpdateEndpointResponse::builder).logger(LOG, "updateEndpoint").serviceDetails("DataConnectivityManagement", "UpdateEndpoint", "").method(Method.PUT).requestBuilder(UpdateEndpointRequest::builder).basePath("/20210217").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).appendQueryParam("registryId", (Object)request.getRegistryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Endpoint.class, UpdateEndpointResponse.Builder::endpoint).handleResponseHeaderString("etag", UpdateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateEndpointResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFolderResponse> updateFolder(UpdateFolderRequest request, AsyncHandler<UpdateFolderRequest, UpdateFolderResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFolderDetails(), "updateFolderDetails is required");
        return this.clientCall(request, UpdateFolderResponse::builder).logger(LOG, "updateFolder").serviceDetails("DataConnectivityManagement", "UpdateFolder", "").method(Method.PUT).requestBuilder(UpdateFolderRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).appendPathParam("folders").appendPathParam(request.getFolderKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Folder.class, UpdateFolderResponse.Builder::folder).handleResponseHeaderString("etag", UpdateFolderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateFolderResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateRegistryResponse> updateRegistry(UpdateRegistryRequest request, AsyncHandler<UpdateRegistryRequest, UpdateRegistryResponse> handler) {
        Validate.notBlank((String)request.getRegistryId(), (String)"registryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRegistryDetails(), "updateRegistryDetails is required");
        return this.clientCall(request, UpdateRegistryResponse::builder).logger(LOG, "updateRegistry").serviceDetails("DataConnectivityManagement", "UpdateRegistry", "").method(Method.PUT).requestBuilder(UpdateRegistryRequest::builder).basePath("/20210217").appendPathParam("registries").appendPathParam(request.getRegistryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Registry.class, UpdateRegistryResponse.Builder::registry).handleResponseHeaderString("etag", UpdateRegistryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRegistryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateRegistryResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ValidateDataAssetNetworkReachablityResponse> validateDataAssetNetworkReachablity(ValidateDataAssetNetworkReachablityRequest request, AsyncHandler<ValidateDataAssetNetworkReachablityRequest, ValidateDataAssetNetworkReachablityResponse> handler) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ValidateDataAssetNetworkReachablityResponse::builder).logger(LOG, "validateDataAssetNetworkReachablity").serviceDetails("DataConnectivityManagement", "ValidateDataAssetNetworkReachablity", "").method(Method.POST).requestBuilder(ValidateDataAssetNetworkReachablityRequest::builder).basePath("/20210217").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).appendPathParam("actions").appendPathParam("validateDataAssetNetworkReachablity").appendQueryParam("registryId", (Object)request.getRegistryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", ValidateDataAssetNetworkReachablityResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ValidateDataAssetNetworkReachablityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public DataConnectivityManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DataConnectivityManagementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataConnectivityManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DataConnectivityManagementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataConnectivityManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DataConnectivityManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataConnectivityManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DataConnectivityManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DataConnectivityManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DataConnectivityManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DataConnectivityManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DataConnectivityManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DataConnectivityManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataConnectivityManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataConnectivityManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DataConnectivityManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DataConnectivityManagementAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

