/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDatabaseToolsEndpointServiceRequest
extends BmcRequest<Void> {
    private String databaseToolsEndpointServiceId;
    private String opcRequestId;

    public String getDatabaseToolsEndpointServiceId() {
        return this.databaseToolsEndpointServiceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().databaseToolsEndpointServiceId(this.databaseToolsEndpointServiceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseToolsEndpointServiceId=").append(String.valueOf(this.databaseToolsEndpointServiceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDatabaseToolsEndpointServiceRequest)) {
            return false;
        }
        GetDatabaseToolsEndpointServiceRequest other = (GetDatabaseToolsEndpointServiceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseToolsEndpointServiceId, other.databaseToolsEndpointServiceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseToolsEndpointServiceId == null ? 43 : this.databaseToolsEndpointServiceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDatabaseToolsEndpointServiceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseToolsEndpointServiceId = null;
        private String opcRequestId = null;

        public Builder databaseToolsEndpointServiceId(String databaseToolsEndpointServiceId) {
            this.databaseToolsEndpointServiceId = databaseToolsEndpointServiceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDatabaseToolsEndpointServiceRequest o) {
            this.databaseToolsEndpointServiceId(o.getDatabaseToolsEndpointServiceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDatabaseToolsEndpointServiceRequest build() {
            GetDatabaseToolsEndpointServiceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDatabaseToolsEndpointServiceRequest buildWithoutInvocationCallback() {
            GetDatabaseToolsEndpointServiceRequest request = new GetDatabaseToolsEndpointServiceRequest();
            request.databaseToolsEndpointServiceId = this.databaseToolsEndpointServiceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

