/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDatabaseToolsConnectionRequest
extends BmcRequest<Void> {
    private String databaseToolsConnectionId;
    private String opcRequestId;

    public String getDatabaseToolsConnectionId() {
        return this.databaseToolsConnectionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().databaseToolsConnectionId(this.databaseToolsConnectionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseToolsConnectionId=").append(String.valueOf(this.databaseToolsConnectionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDatabaseToolsConnectionRequest)) {
            return false;
        }
        GetDatabaseToolsConnectionRequest other = (GetDatabaseToolsConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseToolsConnectionId, other.databaseToolsConnectionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseToolsConnectionId == null ? 43 : this.databaseToolsConnectionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDatabaseToolsConnectionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseToolsConnectionId = null;
        private String opcRequestId = null;

        public Builder databaseToolsConnectionId(String databaseToolsConnectionId) {
            this.databaseToolsConnectionId = databaseToolsConnectionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDatabaseToolsConnectionRequest o) {
            this.databaseToolsConnectionId(o.getDatabaseToolsConnectionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDatabaseToolsConnectionRequest build() {
            GetDatabaseToolsConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDatabaseToolsConnectionRequest buildWithoutInvocationCallback() {
            GetDatabaseToolsConnectionRequest request = new GetDatabaseToolsConnectionRequest();
            request.databaseToolsConnectionId = this.databaseToolsConnectionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

