/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemigration.model.StartMigrationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class StartMigrationRequest
extends BmcRequest<StartMigrationDetails> {
    private String migrationId;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;
    private StartMigrationDetails startMigrationDetails;

    public String getMigrationId() {
        return this.migrationId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public StartMigrationDetails getStartMigrationDetails() {
        return this.startMigrationDetails;
    }

    @InternalSdk
    public StartMigrationDetails getBody$() {
        return this.startMigrationDetails;
    }

    public Builder toBuilder() {
        return new Builder().migrationId(this.migrationId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).startMigrationDetails(this.startMigrationDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",migrationId=").append(String.valueOf(this.migrationId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",startMigrationDetails=").append(String.valueOf((Object)this.startMigrationDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StartMigrationRequest)) {
            return false;
        }
        StartMigrationRequest other = (StartMigrationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.migrationId, other.migrationId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.startMigrationDetails, (Object)other.startMigrationDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.migrationId == null ? 43 : this.migrationId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.startMigrationDetails == null ? 43 : this.startMigrationDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<StartMigrationRequest, StartMigrationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String migrationId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private StartMigrationDetails startMigrationDetails = null;

        public Builder migrationId(String migrationId) {
            this.migrationId = migrationId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder startMigrationDetails(StartMigrationDetails startMigrationDetails) {
            this.startMigrationDetails = startMigrationDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(StartMigrationRequest o) {
            this.migrationId(o.getMigrationId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.startMigrationDetails(o.getStartMigrationDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public StartMigrationRequest build() {
            StartMigrationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(StartMigrationDetails body) {
            this.startMigrationDetails(body);
            return this;
        }

        public StartMigrationRequest buildWithoutInvocationCallback() {
            StartMigrationRequest request = new StartMigrationRequest();
            request.migrationId = this.migrationId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.startMigrationDetails = this.startMigrationDetails;
            return request;
        }
    }
}

