/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemigration.model.ChangeMigrationCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeMigrationCompartmentRequest
extends BmcRequest<ChangeMigrationCompartmentDetails> {
    private String migrationId;
    private ChangeMigrationCompartmentDetails changeMigrationCompartmentDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private String ifMatch;

    public String getMigrationId() {
        return this.migrationId;
    }

    public ChangeMigrationCompartmentDetails getChangeMigrationCompartmentDetails() {
        return this.changeMigrationCompartmentDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ChangeMigrationCompartmentDetails getBody$() {
        return this.changeMigrationCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().migrationId(this.migrationId).changeMigrationCompartmentDetails(this.changeMigrationCompartmentDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",migrationId=").append(String.valueOf(this.migrationId));
        sb.append(",changeMigrationCompartmentDetails=").append(String.valueOf((Object)this.changeMigrationCompartmentDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeMigrationCompartmentRequest)) {
            return false;
        }
        ChangeMigrationCompartmentRequest other = (ChangeMigrationCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.migrationId, other.migrationId) && Objects.equals((Object)this.changeMigrationCompartmentDetails, (Object)other.changeMigrationCompartmentDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.migrationId == null ? 43 : this.migrationId.hashCode());
        result = result * 59 + (this.changeMigrationCompartmentDetails == null ? 43 : this.changeMigrationCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeMigrationCompartmentRequest, ChangeMigrationCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String migrationId = null;
        private ChangeMigrationCompartmentDetails changeMigrationCompartmentDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder migrationId(String migrationId) {
            this.migrationId = migrationId;
            return this;
        }

        public Builder changeMigrationCompartmentDetails(ChangeMigrationCompartmentDetails changeMigrationCompartmentDetails) {
            this.changeMigrationCompartmentDetails = changeMigrationCompartmentDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeMigrationCompartmentRequest o) {
            this.migrationId(o.getMigrationId());
            this.changeMigrationCompartmentDetails(o.getChangeMigrationCompartmentDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeMigrationCompartmentRequest build() {
            ChangeMigrationCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeMigrationCompartmentDetails body) {
            this.changeMigrationCompartmentDetails(body);
            return this;
        }

        public ChangeMigrationCompartmentRequest buildWithoutInvocationCallback() {
            ChangeMigrationCompartmentRequest request = new ChangeMigrationCompartmentRequest();
            request.migrationId = this.migrationId;
            request.changeMigrationCompartmentDetails = this.changeMigrationCompartmentDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

