/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.JobPhaseStatus;
import com.oracle.bmc.databasemigration.model.OdmsJobPhases;
import com.oracle.bmc.databasemigration.model.PhaseStatus;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MigrationJobProgressResource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="currentStatus")
    private final JobPhaseStatus currentStatus;
    @JsonProperty(value="currentPhase")
    private final OdmsJobPhases currentPhase;
    @JsonProperty(value="phases")
    private final List<PhaseStatus> phases;

    @Deprecated
    @ConstructorProperties(value={"currentStatus", "currentPhase", "phases"})
    public MigrationJobProgressResource(JobPhaseStatus currentStatus, OdmsJobPhases currentPhase, List<PhaseStatus> phases) {
        this.currentStatus = currentStatus;
        this.currentPhase = currentPhase;
        this.phases = phases;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public JobPhaseStatus getCurrentStatus() {
        return this.currentStatus;
    }

    public OdmsJobPhases getCurrentPhase() {
        return this.currentPhase;
    }

    public List<PhaseStatus> getPhases() {
        return this.phases;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MigrationJobProgressResource(");
        sb.append("super=").append(super.toString());
        sb.append("currentStatus=").append(String.valueOf((Object)this.currentStatus));
        sb.append(", currentPhase=").append(String.valueOf((Object)this.currentPhase));
        sb.append(", phases=").append(String.valueOf(this.phases));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigrationJobProgressResource)) {
            return false;
        }
        MigrationJobProgressResource other = (MigrationJobProgressResource)((Object)o);
        return Objects.equals((Object)this.currentStatus, (Object)other.currentStatus) && Objects.equals((Object)this.currentPhase, (Object)other.currentPhase) && Objects.equals(this.phases, other.phases) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.currentStatus == null ? 43 : this.currentStatus.hashCode());
        result = result * 59 + (this.currentPhase == null ? 43 : this.currentPhase.hashCode());
        result = result * 59 + (this.phases == null ? 43 : this.phases.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="currentStatus")
        private JobPhaseStatus currentStatus;
        @JsonProperty(value="currentPhase")
        private OdmsJobPhases currentPhase;
        @JsonProperty(value="phases")
        private List<PhaseStatus> phases;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder currentStatus(JobPhaseStatus currentStatus) {
            this.currentStatus = currentStatus;
            this.__explicitlySet__.add("currentStatus");
            return this;
        }

        public Builder currentPhase(OdmsJobPhases currentPhase) {
            this.currentPhase = currentPhase;
            this.__explicitlySet__.add("currentPhase");
            return this;
        }

        public Builder phases(List<PhaseStatus> phases) {
            this.phases = phases;
            this.__explicitlySet__.add("phases");
            return this;
        }

        public MigrationJobProgressResource build() {
            MigrationJobProgressResource model = new MigrationJobProgressResource(this.currentStatus, this.currentPhase, this.phases);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MigrationJobProgressResource model) {
            if (model.wasPropertyExplicitlySet("currentStatus")) {
                this.currentStatus(model.getCurrentStatus());
            }
            if (model.wasPropertyExplicitlySet("currentPhase")) {
                this.currentPhase(model.getCurrentPhase());
            }
            if (model.wasPropertyExplicitlySet("phases")) {
                this.phases(model.getPhases());
            }
            return this;
        }
    }
}

