/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.CreateDataPumpParameters;
import com.oracle.bmc.databasemigration.model.CreateDirectoryObject;
import com.oracle.bmc.databasemigration.model.CreateTargetTypeTablespaceDetails;
import com.oracle.bmc.databasemigration.model.DataPumpJobMode;
import com.oracle.bmc.databasemigration.model.MetadataRemap;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateDataPumpSettings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="jobMode")
    private final DataPumpJobMode jobMode;
    @JsonProperty(value="dataPumpParameters")
    private final CreateDataPumpParameters dataPumpParameters;
    @JsonProperty(value="metadataRemaps")
    private final List<MetadataRemap> metadataRemaps;
    @JsonProperty(value="tablespaceDetails")
    private final CreateTargetTypeTablespaceDetails tablespaceDetails;
    @JsonProperty(value="exportDirectoryObject")
    private final CreateDirectoryObject exportDirectoryObject;
    @JsonProperty(value="importDirectoryObject")
    private final CreateDirectoryObject importDirectoryObject;

    @Deprecated
    @ConstructorProperties(value={"jobMode", "dataPumpParameters", "metadataRemaps", "tablespaceDetails", "exportDirectoryObject", "importDirectoryObject"})
    public CreateDataPumpSettings(DataPumpJobMode jobMode, CreateDataPumpParameters dataPumpParameters, List<MetadataRemap> metadataRemaps, CreateTargetTypeTablespaceDetails tablespaceDetails, CreateDirectoryObject exportDirectoryObject, CreateDirectoryObject importDirectoryObject) {
        this.jobMode = jobMode;
        this.dataPumpParameters = dataPumpParameters;
        this.metadataRemaps = metadataRemaps;
        this.tablespaceDetails = tablespaceDetails;
        this.exportDirectoryObject = exportDirectoryObject;
        this.importDirectoryObject = importDirectoryObject;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DataPumpJobMode getJobMode() {
        return this.jobMode;
    }

    public CreateDataPumpParameters getDataPumpParameters() {
        return this.dataPumpParameters;
    }

    public List<MetadataRemap> getMetadataRemaps() {
        return this.metadataRemaps;
    }

    public CreateTargetTypeTablespaceDetails getTablespaceDetails() {
        return this.tablespaceDetails;
    }

    public CreateDirectoryObject getExportDirectoryObject() {
        return this.exportDirectoryObject;
    }

    public CreateDirectoryObject getImportDirectoryObject() {
        return this.importDirectoryObject;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDataPumpSettings(");
        sb.append("super=").append(super.toString());
        sb.append("jobMode=").append(String.valueOf((Object)this.jobMode));
        sb.append(", dataPumpParameters=").append(String.valueOf((Object)this.dataPumpParameters));
        sb.append(", metadataRemaps=").append(String.valueOf(this.metadataRemaps));
        sb.append(", tablespaceDetails=").append(String.valueOf((Object)this.tablespaceDetails));
        sb.append(", exportDirectoryObject=").append(String.valueOf((Object)this.exportDirectoryObject));
        sb.append(", importDirectoryObject=").append(String.valueOf((Object)this.importDirectoryObject));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDataPumpSettings)) {
            return false;
        }
        CreateDataPumpSettings other = (CreateDataPumpSettings)((Object)o);
        return Objects.equals((Object)this.jobMode, (Object)other.jobMode) && Objects.equals((Object)this.dataPumpParameters, (Object)other.dataPumpParameters) && Objects.equals(this.metadataRemaps, other.metadataRemaps) && Objects.equals((Object)this.tablespaceDetails, (Object)other.tablespaceDetails) && Objects.equals((Object)this.exportDirectoryObject, (Object)other.exportDirectoryObject) && Objects.equals((Object)this.importDirectoryObject, (Object)other.importDirectoryObject) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.jobMode == null ? 43 : this.jobMode.hashCode());
        result = result * 59 + (this.dataPumpParameters == null ? 43 : this.dataPumpParameters.hashCode());
        result = result * 59 + (this.metadataRemaps == null ? 43 : this.metadataRemaps.hashCode());
        result = result * 59 + (this.tablespaceDetails == null ? 43 : this.tablespaceDetails.hashCode());
        result = result * 59 + (this.exportDirectoryObject == null ? 43 : this.exportDirectoryObject.hashCode());
        result = result * 59 + (this.importDirectoryObject == null ? 43 : this.importDirectoryObject.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="jobMode")
        private DataPumpJobMode jobMode;
        @JsonProperty(value="dataPumpParameters")
        private CreateDataPumpParameters dataPumpParameters;
        @JsonProperty(value="metadataRemaps")
        private List<MetadataRemap> metadataRemaps;
        @JsonProperty(value="tablespaceDetails")
        private CreateTargetTypeTablespaceDetails tablespaceDetails;
        @JsonProperty(value="exportDirectoryObject")
        private CreateDirectoryObject exportDirectoryObject;
        @JsonProperty(value="importDirectoryObject")
        private CreateDirectoryObject importDirectoryObject;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder jobMode(DataPumpJobMode jobMode) {
            this.jobMode = jobMode;
            this.__explicitlySet__.add("jobMode");
            return this;
        }

        public Builder dataPumpParameters(CreateDataPumpParameters dataPumpParameters) {
            this.dataPumpParameters = dataPumpParameters;
            this.__explicitlySet__.add("dataPumpParameters");
            return this;
        }

        public Builder metadataRemaps(List<MetadataRemap> metadataRemaps) {
            this.metadataRemaps = metadataRemaps;
            this.__explicitlySet__.add("metadataRemaps");
            return this;
        }

        public Builder tablespaceDetails(CreateTargetTypeTablespaceDetails tablespaceDetails) {
            this.tablespaceDetails = tablespaceDetails;
            this.__explicitlySet__.add("tablespaceDetails");
            return this;
        }

        public Builder exportDirectoryObject(CreateDirectoryObject exportDirectoryObject) {
            this.exportDirectoryObject = exportDirectoryObject;
            this.__explicitlySet__.add("exportDirectoryObject");
            return this;
        }

        public Builder importDirectoryObject(CreateDirectoryObject importDirectoryObject) {
            this.importDirectoryObject = importDirectoryObject;
            this.__explicitlySet__.add("importDirectoryObject");
            return this;
        }

        public CreateDataPumpSettings build() {
            CreateDataPumpSettings model = new CreateDataPumpSettings(this.jobMode, this.dataPumpParameters, this.metadataRemaps, this.tablespaceDetails, this.exportDirectoryObject, this.importDirectoryObject);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDataPumpSettings model) {
            if (model.wasPropertyExplicitlySet("jobMode")) {
                this.jobMode(model.getJobMode());
            }
            if (model.wasPropertyExplicitlySet("dataPumpParameters")) {
                this.dataPumpParameters(model.getDataPumpParameters());
            }
            if (model.wasPropertyExplicitlySet("metadataRemaps")) {
                this.metadataRemaps(model.getMetadataRemaps());
            }
            if (model.wasPropertyExplicitlySet("tablespaceDetails")) {
                this.tablespaceDetails(model.getTablespaceDetails());
            }
            if (model.wasPropertyExplicitlySet("exportDirectoryObject")) {
                this.exportDirectoryObject(model.getExportDirectoryObject());
            }
            if (model.wasPropertyExplicitlySet("importDirectoryObject")) {
                this.importDirectoryObject(model.getImportDirectoryObject());
            }
            return this;
        }
    }
}

