/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.DataPumpEstimate;
import com.oracle.bmc.databasemigration.model.DataPumpExcludeParameters;
import com.oracle.bmc.databasemigration.model.DataPumpTableExistsAction;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateDataPumpParameters
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isCluster")
    private final Boolean isCluster;
    @JsonProperty(value="estimate")
    private final DataPumpEstimate estimate;
    @JsonProperty(value="tableExistsAction")
    private final DataPumpTableExistsAction tableExistsAction;
    @JsonProperty(value="excludeParameters")
    private final List<DataPumpExcludeParameters> excludeParameters;
    @JsonProperty(value="importParallelismDegree")
    private final Integer importParallelismDegree;
    @JsonProperty(value="exportParallelismDegree")
    private final Integer exportParallelismDegree;

    @Deprecated
    @ConstructorProperties(value={"isCluster", "estimate", "tableExistsAction", "excludeParameters", "importParallelismDegree", "exportParallelismDegree"})
    public CreateDataPumpParameters(Boolean isCluster, DataPumpEstimate estimate, DataPumpTableExistsAction tableExistsAction, List<DataPumpExcludeParameters> excludeParameters, Integer importParallelismDegree, Integer exportParallelismDegree) {
        this.isCluster = isCluster;
        this.estimate = estimate;
        this.tableExistsAction = tableExistsAction;
        this.excludeParameters = excludeParameters;
        this.importParallelismDegree = importParallelismDegree;
        this.exportParallelismDegree = exportParallelismDegree;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsCluster() {
        return this.isCluster;
    }

    public DataPumpEstimate getEstimate() {
        return this.estimate;
    }

    public DataPumpTableExistsAction getTableExistsAction() {
        return this.tableExistsAction;
    }

    public List<DataPumpExcludeParameters> getExcludeParameters() {
        return this.excludeParameters;
    }

    public Integer getImportParallelismDegree() {
        return this.importParallelismDegree;
    }

    public Integer getExportParallelismDegree() {
        return this.exportParallelismDegree;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDataPumpParameters(");
        sb.append("super=").append(super.toString());
        sb.append("isCluster=").append(String.valueOf(this.isCluster));
        sb.append(", estimate=").append(String.valueOf((Object)this.estimate));
        sb.append(", tableExistsAction=").append(String.valueOf((Object)this.tableExistsAction));
        sb.append(", excludeParameters=").append(String.valueOf(this.excludeParameters));
        sb.append(", importParallelismDegree=").append(String.valueOf(this.importParallelismDegree));
        sb.append(", exportParallelismDegree=").append(String.valueOf(this.exportParallelismDegree));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDataPumpParameters)) {
            return false;
        }
        CreateDataPumpParameters other = (CreateDataPumpParameters)((Object)o);
        return Objects.equals(this.isCluster, other.isCluster) && Objects.equals((Object)this.estimate, (Object)other.estimate) && Objects.equals((Object)this.tableExistsAction, (Object)other.tableExistsAction) && Objects.equals(this.excludeParameters, other.excludeParameters) && Objects.equals(this.importParallelismDegree, other.importParallelismDegree) && Objects.equals(this.exportParallelismDegree, other.exportParallelismDegree) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCluster == null ? 43 : this.isCluster.hashCode());
        result = result * 59 + (this.estimate == null ? 43 : this.estimate.hashCode());
        result = result * 59 + (this.tableExistsAction == null ? 43 : this.tableExistsAction.hashCode());
        result = result * 59 + (this.excludeParameters == null ? 43 : this.excludeParameters.hashCode());
        result = result * 59 + (this.importParallelismDegree == null ? 43 : this.importParallelismDegree.hashCode());
        result = result * 59 + (this.exportParallelismDegree == null ? 43 : this.exportParallelismDegree.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isCluster")
        private Boolean isCluster;
        @JsonProperty(value="estimate")
        private DataPumpEstimate estimate;
        @JsonProperty(value="tableExistsAction")
        private DataPumpTableExistsAction tableExistsAction;
        @JsonProperty(value="excludeParameters")
        private List<DataPumpExcludeParameters> excludeParameters;
        @JsonProperty(value="importParallelismDegree")
        private Integer importParallelismDegree;
        @JsonProperty(value="exportParallelismDegree")
        private Integer exportParallelismDegree;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isCluster(Boolean isCluster) {
            this.isCluster = isCluster;
            this.__explicitlySet__.add("isCluster");
            return this;
        }

        public Builder estimate(DataPumpEstimate estimate) {
            this.estimate = estimate;
            this.__explicitlySet__.add("estimate");
            return this;
        }

        public Builder tableExistsAction(DataPumpTableExistsAction tableExistsAction) {
            this.tableExistsAction = tableExistsAction;
            this.__explicitlySet__.add("tableExistsAction");
            return this;
        }

        public Builder excludeParameters(List<DataPumpExcludeParameters> excludeParameters) {
            this.excludeParameters = excludeParameters;
            this.__explicitlySet__.add("excludeParameters");
            return this;
        }

        public Builder importParallelismDegree(Integer importParallelismDegree) {
            this.importParallelismDegree = importParallelismDegree;
            this.__explicitlySet__.add("importParallelismDegree");
            return this;
        }

        public Builder exportParallelismDegree(Integer exportParallelismDegree) {
            this.exportParallelismDegree = exportParallelismDegree;
            this.__explicitlySet__.add("exportParallelismDegree");
            return this;
        }

        public CreateDataPumpParameters build() {
            CreateDataPumpParameters model = new CreateDataPumpParameters(this.isCluster, this.estimate, this.tableExistsAction, this.excludeParameters, this.importParallelismDegree, this.exportParallelismDegree);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDataPumpParameters model) {
            if (model.wasPropertyExplicitlySet("isCluster")) {
                this.isCluster(model.getIsCluster());
            }
            if (model.wasPropertyExplicitlySet("estimate")) {
                this.estimate(model.getEstimate());
            }
            if (model.wasPropertyExplicitlySet("tableExistsAction")) {
                this.tableExistsAction(model.getTableExistsAction());
            }
            if (model.wasPropertyExplicitlySet("excludeParameters")) {
                this.excludeParameters(model.getExcludeParameters());
            }
            if (model.wasPropertyExplicitlySet("importParallelismDegree")) {
                this.importParallelismDegree(model.getImportParallelismDegree());
            }
            if (model.wasPropertyExplicitlySet("exportParallelismDegree")) {
                this.exportParallelismDegree(model.getExportParallelismDegree());
            }
            return this;
        }
    }
}

