/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.responses;

import com.oracle.bmc.databasemanagement.model.RoleCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListRolesResponse
extends BmcResponse {
    private String opcNextPage;
    private String opcRequestId;
    private RoleCollection roleCollection;

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public RoleCollection getRoleCollection() {
        return this.roleCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcNextPage", "opcRequestId", "roleCollection"})
    private ListRolesResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcNextPage, String opcRequestId, RoleCollection roleCollection) {
        super(__httpStatusCode__, headers);
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.roleCollection = roleCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",roleCollection=").append(String.valueOf((Object)this.roleCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRolesResponse)) {
            return false;
        }
        ListRolesResponse other = (ListRolesResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.roleCollection, (Object)other.roleCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.roleCollection == null ? 43 : this.roleCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListRolesResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcNextPage;
        private String opcRequestId;
        private RoleCollection roleCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder roleCollection(RoleCollection roleCollection) {
            this.roleCollection = roleCollection;
            return this;
        }

        public Builder copy(ListRolesResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.roleCollection(o.getRoleCollection());
            return this;
        }

        public ListRolesResponse build() {
            return new ListRolesResponse(this.__httpStatusCode__, this.headers, this.opcNextPage, this.opcRequestId, this.roleCollection);
        }
    }
}

