/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.responses;

import com.oracle.bmc.databasemanagement.model.ManagedDatabaseGroup;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateManagedDatabaseGroupResponse
extends BmcResponse {
    private String location;
    private String opcRequestId;
    private String etag;
    private ManagedDatabaseGroup managedDatabaseGroup;

    public String getLocation() {
        return this.location;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public ManagedDatabaseGroup getManagedDatabaseGroup() {
        return this.managedDatabaseGroup;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "location", "opcRequestId", "etag", "managedDatabaseGroup"})
    private CreateManagedDatabaseGroupResponse(int __httpStatusCode__, Map<String, List<String>> headers, String location, String opcRequestId, String etag, ManagedDatabaseGroup managedDatabaseGroup) {
        super(__httpStatusCode__, headers);
        this.location = location;
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.managedDatabaseGroup = managedDatabaseGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",managedDatabaseGroup=").append(String.valueOf((Object)this.managedDatabaseGroup));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateManagedDatabaseGroupResponse)) {
            return false;
        }
        CreateManagedDatabaseGroupResponse other = (CreateManagedDatabaseGroupResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.location, other.location) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.managedDatabaseGroup, (Object)other.managedDatabaseGroup);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.managedDatabaseGroup == null ? 43 : this.managedDatabaseGroup.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateManagedDatabaseGroupResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String location;
        private String opcRequestId;
        private String etag;
        private ManagedDatabaseGroup managedDatabaseGroup;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder managedDatabaseGroup(ManagedDatabaseGroup managedDatabaseGroup) {
            this.managedDatabaseGroup = managedDatabaseGroup;
            return this;
        }

        public Builder copy(CreateManagedDatabaseGroupResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.location(o.getLocation());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.managedDatabaseGroup(o.getManagedDatabaseGroup());
            return this;
        }

        public CreateManagedDatabaseGroupResponse build() {
            return new CreateManagedDatabaseGroupResponse(this.__httpStatusCode__, this.headers, this.location, this.opcRequestId, this.etag, this.managedDatabaseGroup);
        }
    }
}

