/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.ResetDatabaseParametersDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ResetDatabaseParametersRequest
extends BmcRequest<ResetDatabaseParametersDetails> {
    private String managedDatabaseId;
    private ResetDatabaseParametersDetails resetDatabaseParametersDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public ResetDatabaseParametersDetails getResetDatabaseParametersDetails() {
        return this.resetDatabaseParametersDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ResetDatabaseParametersDetails getBody$() {
        return this.resetDatabaseParametersDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).resetDatabaseParametersDetails(this.resetDatabaseParametersDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",resetDatabaseParametersDetails=").append(String.valueOf((Object)this.resetDatabaseParametersDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResetDatabaseParametersRequest)) {
            return false;
        }
        ResetDatabaseParametersRequest other = (ResetDatabaseParametersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals((Object)this.resetDatabaseParametersDetails, (Object)other.resetDatabaseParametersDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.resetDatabaseParametersDetails == null ? 43 : this.resetDatabaseParametersDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ResetDatabaseParametersRequest, ResetDatabaseParametersDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private ResetDatabaseParametersDetails resetDatabaseParametersDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder resetDatabaseParametersDetails(ResetDatabaseParametersDetails resetDatabaseParametersDetails) {
            this.resetDatabaseParametersDetails = resetDatabaseParametersDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ResetDatabaseParametersRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.resetDatabaseParametersDetails(o.getResetDatabaseParametersDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ResetDatabaseParametersRequest build() {
            ResetDatabaseParametersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ResetDatabaseParametersDetails body) {
            this.resetDatabaseParametersDetails(body);
            return this;
        }

        public ResetDatabaseParametersRequest buildWithoutInvocationCallback() {
            ResetDatabaseParametersRequest request = new ResetDatabaseParametersRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.resetDatabaseParametersDetails = this.resetDatabaseParametersDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

