/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.databasemanagement.model.CompareType;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDatabaseFleetHealthMetricsRequest
extends BmcRequest<Void> {
    private String compareBaselineTime;
    private String compareTargetTime;
    private String opcRequestId;
    private String managedDatabaseGroupId;
    private String compartmentId;
    private CompareType compareType;
    private String filterByMetricNames;
    private String filterByDatabaseType;
    private String filterByDatabaseSubType;
    private String filterByDatabaseDeploymentType;
    private String filterByDatabaseVersion;

    public String getCompareBaselineTime() {
        return this.compareBaselineTime;
    }

    public String getCompareTargetTime() {
        return this.compareTargetTime;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getManagedDatabaseGroupId() {
        return this.managedDatabaseGroupId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public String getFilterByMetricNames() {
        return this.filterByMetricNames;
    }

    public String getFilterByDatabaseType() {
        return this.filterByDatabaseType;
    }

    public String getFilterByDatabaseSubType() {
        return this.filterByDatabaseSubType;
    }

    public String getFilterByDatabaseDeploymentType() {
        return this.filterByDatabaseDeploymentType;
    }

    public String getFilterByDatabaseVersion() {
        return this.filterByDatabaseVersion;
    }

    public Builder toBuilder() {
        return new Builder().compareBaselineTime(this.compareBaselineTime).compareTargetTime(this.compareTargetTime).opcRequestId(this.opcRequestId).managedDatabaseGroupId(this.managedDatabaseGroupId).compartmentId(this.compartmentId).compareType(this.compareType).filterByMetricNames(this.filterByMetricNames).filterByDatabaseType(this.filterByDatabaseType).filterByDatabaseSubType(this.filterByDatabaseSubType).filterByDatabaseDeploymentType(this.filterByDatabaseDeploymentType).filterByDatabaseVersion(this.filterByDatabaseVersion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compareBaselineTime=").append(String.valueOf(this.compareBaselineTime));
        sb.append(",compareTargetTime=").append(String.valueOf(this.compareTargetTime));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",managedDatabaseGroupId=").append(String.valueOf(this.managedDatabaseGroupId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",compareType=").append(String.valueOf((Object)this.compareType));
        sb.append(",filterByMetricNames=").append(String.valueOf(this.filterByMetricNames));
        sb.append(",filterByDatabaseType=").append(String.valueOf(this.filterByDatabaseType));
        sb.append(",filterByDatabaseSubType=").append(String.valueOf(this.filterByDatabaseSubType));
        sb.append(",filterByDatabaseDeploymentType=").append(String.valueOf(this.filterByDatabaseDeploymentType));
        sb.append(",filterByDatabaseVersion=").append(String.valueOf(this.filterByDatabaseVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDatabaseFleetHealthMetricsRequest)) {
            return false;
        }
        GetDatabaseFleetHealthMetricsRequest other = (GetDatabaseFleetHealthMetricsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compareBaselineTime, other.compareBaselineTime) && Objects.equals(this.compareTargetTime, other.compareTargetTime) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.managedDatabaseGroupId, other.managedDatabaseGroupId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.compareType, (Object)other.compareType) && Objects.equals(this.filterByMetricNames, other.filterByMetricNames) && Objects.equals(this.filterByDatabaseType, other.filterByDatabaseType) && Objects.equals(this.filterByDatabaseSubType, other.filterByDatabaseSubType) && Objects.equals(this.filterByDatabaseDeploymentType, other.filterByDatabaseDeploymentType) && Objects.equals(this.filterByDatabaseVersion, other.filterByDatabaseVersion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compareBaselineTime == null ? 43 : this.compareBaselineTime.hashCode());
        result = result * 59 + (this.compareTargetTime == null ? 43 : this.compareTargetTime.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.managedDatabaseGroupId == null ? 43 : this.managedDatabaseGroupId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compareType == null ? 43 : this.compareType.hashCode());
        result = result * 59 + (this.filterByMetricNames == null ? 43 : this.filterByMetricNames.hashCode());
        result = result * 59 + (this.filterByDatabaseType == null ? 43 : this.filterByDatabaseType.hashCode());
        result = result * 59 + (this.filterByDatabaseSubType == null ? 43 : this.filterByDatabaseSubType.hashCode());
        result = result * 59 + (this.filterByDatabaseDeploymentType == null ? 43 : this.filterByDatabaseDeploymentType.hashCode());
        result = result * 59 + (this.filterByDatabaseVersion == null ? 43 : this.filterByDatabaseVersion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDatabaseFleetHealthMetricsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compareBaselineTime = null;
        private String compareTargetTime = null;
        private String opcRequestId = null;
        private String managedDatabaseGroupId = null;
        private String compartmentId = null;
        private CompareType compareType = null;
        private String filterByMetricNames = null;
        private String filterByDatabaseType = null;
        private String filterByDatabaseSubType = null;
        private String filterByDatabaseDeploymentType = null;
        private String filterByDatabaseVersion = null;

        public Builder compareBaselineTime(String compareBaselineTime) {
            this.compareBaselineTime = compareBaselineTime;
            return this;
        }

        public Builder compareTargetTime(String compareTargetTime) {
            this.compareTargetTime = compareTargetTime;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder managedDatabaseGroupId(String managedDatabaseGroupId) {
            this.managedDatabaseGroupId = managedDatabaseGroupId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compareType(CompareType compareType) {
            this.compareType = compareType;
            return this;
        }

        public Builder filterByMetricNames(String filterByMetricNames) {
            this.filterByMetricNames = filterByMetricNames;
            return this;
        }

        public Builder filterByDatabaseType(String filterByDatabaseType) {
            this.filterByDatabaseType = filterByDatabaseType;
            return this;
        }

        public Builder filterByDatabaseSubType(String filterByDatabaseSubType) {
            this.filterByDatabaseSubType = filterByDatabaseSubType;
            return this;
        }

        public Builder filterByDatabaseDeploymentType(String filterByDatabaseDeploymentType) {
            this.filterByDatabaseDeploymentType = filterByDatabaseDeploymentType;
            return this;
        }

        public Builder filterByDatabaseVersion(String filterByDatabaseVersion) {
            this.filterByDatabaseVersion = filterByDatabaseVersion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDatabaseFleetHealthMetricsRequest o) {
            this.compareBaselineTime(o.getCompareBaselineTime());
            this.compareTargetTime(o.getCompareTargetTime());
            this.opcRequestId(o.getOpcRequestId());
            this.managedDatabaseGroupId(o.getManagedDatabaseGroupId());
            this.compartmentId(o.getCompartmentId());
            this.compareType(o.getCompareType());
            this.filterByMetricNames(o.getFilterByMetricNames());
            this.filterByDatabaseType(o.getFilterByDatabaseType());
            this.filterByDatabaseSubType(o.getFilterByDatabaseSubType());
            this.filterByDatabaseDeploymentType(o.getFilterByDatabaseDeploymentType());
            this.filterByDatabaseVersion(o.getFilterByDatabaseVersion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDatabaseFleetHealthMetricsRequest build() {
            GetDatabaseFleetHealthMetricsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDatabaseFleetHealthMetricsRequest buildWithoutInvocationCallback() {
            GetDatabaseFleetHealthMetricsRequest request = new GetDatabaseFleetHealthMetricsRequest();
            request.compareBaselineTime = this.compareBaselineTime;
            request.compareTargetTime = this.compareTargetTime;
            request.opcRequestId = this.opcRequestId;
            request.managedDatabaseGroupId = this.managedDatabaseGroupId;
            request.compartmentId = this.compartmentId;
            request.compareType = this.compareType;
            request.filterByMetricNames = this.filterByMetricNames;
            request.filterByDatabaseType = this.filterByDatabaseType;
            request.filterByDatabaseSubType = this.filterByDatabaseSubType;
            request.filterByDatabaseDeploymentType = this.filterByDatabaseDeploymentType;
            request.filterByDatabaseVersion = this.filterByDatabaseVersion;
            return request;
        }
    }
}

