/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeletePreferredCredentialRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String credentialName;
    private String opcRequestId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getCredentialName() {
        return this.credentialName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).credentialName(this.credentialName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",credentialName=").append(String.valueOf(this.credentialName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeletePreferredCredentialRequest)) {
            return false;
        }
        DeletePreferredCredentialRequest other = (DeletePreferredCredentialRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.credentialName, other.credentialName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.credentialName == null ? 43 : this.credentialName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeletePreferredCredentialRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String credentialName = null;
        private String opcRequestId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder credentialName(String credentialName) {
            this.credentialName = credentialName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeletePreferredCredentialRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.credentialName(o.getCredentialName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeletePreferredCredentialRequest build() {
            DeletePreferredCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeletePreferredCredentialRequest buildWithoutInvocationCallback() {
            DeletePreferredCredentialRequest request = new DeletePreferredCredentialRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.credentialName = this.credentialName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

