/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.MetricDimensionDefinition;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TimeSeriesMetricDataPoint
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="value")
    private final Double value;
    @JsonProperty(value="unit")
    private final String unit;
    @JsonProperty(value="dimensions")
    private final List<MetricDimensionDefinition> dimensions;

    @Deprecated
    @ConstructorProperties(value={"timestamp", "value", "unit", "dimensions"})
    public TimeSeriesMetricDataPoint(Date timestamp, Double value, String unit, List<MetricDimensionDefinition> dimensions) {
        this.timestamp = timestamp;
        this.value = value;
        this.unit = unit;
        this.dimensions = dimensions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Double getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public List<MetricDimensionDefinition> getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TimeSeriesMetricDataPoint(");
        sb.append("super=").append(super.toString());
        sb.append("timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", unit=").append(String.valueOf(this.unit));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeSeriesMetricDataPoint)) {
            return false;
        }
        TimeSeriesMetricDataPoint other = (TimeSeriesMetricDataPoint)((Object)o);
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.value, other.value) && Objects.equals(this.unit, other.unit) && Objects.equals(this.dimensions, other.dimensions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="value")
        private Double value;
        @JsonProperty(value="unit")
        private String unit;
        @JsonProperty(value="dimensions")
        private List<MetricDimensionDefinition> dimensions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder value(Double value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public Builder dimensions(List<MetricDimensionDefinition> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public TimeSeriesMetricDataPoint build() {
            TimeSeriesMetricDataPoint model = new TimeSeriesMetricDataPoint(this.timestamp, this.value, this.unit, this.dimensions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TimeSeriesMetricDataPoint model) {
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            return this;
        }
    }
}

