/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TablespaceStorageSize
extends ExplicitlySetBmcModel {
    @JsonProperty(value="size")
    private final BigDecimal size;
    @JsonProperty(value="unit")
    private final Unit unit;

    @Deprecated
    @ConstructorProperties(value={"size", "unit"})
    public TablespaceStorageSize(BigDecimal size, Unit unit) {
        this.size = size;
        this.unit = unit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public BigDecimal getSize() {
        return this.size;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TablespaceStorageSize(");
        sb.append("super=").append(super.toString());
        sb.append("size=").append(String.valueOf(this.size));
        sb.append(", unit=").append(String.valueOf((Object)this.unit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TablespaceStorageSize)) {
            return false;
        }
        TablespaceStorageSize other = (TablespaceStorageSize)((Object)o);
        return Objects.equals(this.size, other.size) && Objects.equals((Object)this.unit, (Object)other.unit) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.size == null ? 43 : this.size.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Unit implements BmcEnum
    {
        Bytes("BYTES"),
        Kilobytes("KILOBYTES"),
        Megabytes("MEGABYTES"),
        Gigabytes("GIGABYTES"),
        Terabytes("TERABYTES");

        private final String value;
        private static Map<String, Unit> map;

        private Unit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Unit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Unit: " + key);
        }

        static {
            map = new HashMap<String, Unit>();
            for (Unit v : Unit.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="size")
        private BigDecimal size;
        @JsonProperty(value="unit")
        private Unit unit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder size(BigDecimal size) {
            this.size = size;
            this.__explicitlySet__.add("size");
            return this;
        }

        public Builder unit(Unit unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public TablespaceStorageSize build() {
            TablespaceStorageSize model = new TablespaceStorageSize(this.size, this.unit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TablespaceStorageSize model) {
            if (model.wasPropertyExplicitlySet("size")) {
                this.size(model.getSize());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            return this;
        }
    }
}

