/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlTuningTaskPlanStats
extends ExplicitlySetBmcModel {
    @JsonProperty(value="planType")
    private final String planType;
    @JsonProperty(value="planStats")
    private final Map<String, Double> planStats;
    @JsonProperty(value="planStatus")
    private final PlanStatus planStatus;

    @Deprecated
    @ConstructorProperties(value={"planType", "planStats", "planStatus"})
    public SqlTuningTaskPlanStats(String planType, Map<String, Double> planStats, PlanStatus planStatus) {
        this.planType = planType;
        this.planStats = planStats;
        this.planStatus = planStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPlanType() {
        return this.planType;
    }

    public Map<String, Double> getPlanStats() {
        return this.planStats;
    }

    public PlanStatus getPlanStatus() {
        return this.planStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlTuningTaskPlanStats(");
        sb.append("super=").append(super.toString());
        sb.append("planType=").append(String.valueOf(this.planType));
        sb.append(", planStats=").append(String.valueOf(this.planStats));
        sb.append(", planStatus=").append(String.valueOf((Object)this.planStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlTuningTaskPlanStats)) {
            return false;
        }
        SqlTuningTaskPlanStats other = (SqlTuningTaskPlanStats)((Object)o);
        return Objects.equals(this.planType, other.planType) && Objects.equals(this.planStats, other.planStats) && Objects.equals((Object)this.planStatus, (Object)other.planStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.planType == null ? 43 : this.planType.hashCode());
        result = result * 59 + (this.planStats == null ? 43 : this.planStats.hashCode());
        result = result * 59 + (this.planStatus == null ? 43 : this.planStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PlanStatus implements BmcEnum
    {
        Complete("COMPLETE"),
        Partial("PARTIAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PlanStatus> map;

        private PlanStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlanStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PlanStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PlanStatus.class);
            map = new HashMap<String, PlanStatus>();
            for (PlanStatus v : PlanStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="planType")
        private String planType;
        @JsonProperty(value="planStats")
        private Map<String, Double> planStats;
        @JsonProperty(value="planStatus")
        private PlanStatus planStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder planType(String planType) {
            this.planType = planType;
            this.__explicitlySet__.add("planType");
            return this;
        }

        public Builder planStats(Map<String, Double> planStats) {
            this.planStats = planStats;
            this.__explicitlySet__.add("planStats");
            return this;
        }

        public Builder planStatus(PlanStatus planStatus) {
            this.planStatus = planStatus;
            this.__explicitlySet__.add("planStatus");
            return this;
        }

        public SqlTuningTaskPlanStats build() {
            SqlTuningTaskPlanStats model = new SqlTuningTaskPlanStats(this.planType, this.planStats, this.planStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlTuningTaskPlanStats model) {
            if (model.wasPropertyExplicitlySet("planType")) {
                this.planType(model.getPlanType());
            }
            if (model.wasPropertyExplicitlySet("planStats")) {
                this.planStats(model.getPlanStats());
            }
            if (model.wasPropertyExplicitlySet("planStatus")) {
                this.planStatus(model.getPlanStatus());
            }
            return this;
        }
    }
}

