/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlTuningAdvisorTaskSummaryReportObjectStatFindingSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="objectHashValue")
    private final Long objectHashValue;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="objectType")
    private final String objectType;
    @JsonProperty(value="schema")
    private final String schema;
    @JsonProperty(value="problemType")
    private final ProblemType problemType;
    @JsonProperty(value="referenceCount")
    private final Integer referenceCount;

    @Deprecated
    @ConstructorProperties(value={"objectHashValue", "objectName", "objectType", "schema", "problemType", "referenceCount"})
    public SqlTuningAdvisorTaskSummaryReportObjectStatFindingSummary(Long objectHashValue, String objectName, String objectType, String schema, ProblemType problemType, Integer referenceCount) {
        this.objectHashValue = objectHashValue;
        this.objectName = objectName;
        this.objectType = objectType;
        this.schema = schema;
        this.problemType = problemType;
        this.referenceCount = referenceCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getObjectHashValue() {
        return this.objectHashValue;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getSchema() {
        return this.schema;
    }

    public ProblemType getProblemType() {
        return this.problemType;
    }

    public Integer getReferenceCount() {
        return this.referenceCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlTuningAdvisorTaskSummaryReportObjectStatFindingSummary(");
        sb.append("super=").append(super.toString());
        sb.append("objectHashValue=").append(String.valueOf(this.objectHashValue));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", objectType=").append(String.valueOf(this.objectType));
        sb.append(", schema=").append(String.valueOf(this.schema));
        sb.append(", problemType=").append(String.valueOf((Object)this.problemType));
        sb.append(", referenceCount=").append(String.valueOf(this.referenceCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlTuningAdvisorTaskSummaryReportObjectStatFindingSummary)) {
            return false;
        }
        SqlTuningAdvisorTaskSummaryReportObjectStatFindingSummary other = (SqlTuningAdvisorTaskSummaryReportObjectStatFindingSummary)((Object)o);
        return Objects.equals(this.objectHashValue, other.objectHashValue) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.objectType, other.objectType) && Objects.equals(this.schema, other.schema) && Objects.equals((Object)this.problemType, (Object)other.problemType) && Objects.equals(this.referenceCount, other.referenceCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.objectHashValue == null ? 43 : this.objectHashValue.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.schema == null ? 43 : this.schema.hashCode());
        result = result * 59 + (this.problemType == null ? 43 : this.problemType.hashCode());
        result = result * 59 + (this.referenceCount == null ? 43 : this.referenceCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ProblemType implements BmcEnum
    {
        Missing("MISSING"),
        Stale("STALE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ProblemType> map;

        private ProblemType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProblemType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ProblemType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ProblemType.class);
            map = new HashMap<String, ProblemType>();
            for (ProblemType v : ProblemType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="objectHashValue")
        private Long objectHashValue;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="objectType")
        private String objectType;
        @JsonProperty(value="schema")
        private String schema;
        @JsonProperty(value="problemType")
        private ProblemType problemType;
        @JsonProperty(value="referenceCount")
        private Integer referenceCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder objectHashValue(Long objectHashValue) {
            this.objectHashValue = objectHashValue;
            this.__explicitlySet__.add("objectHashValue");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder objectType(String objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            this.__explicitlySet__.add("schema");
            return this;
        }

        public Builder problemType(ProblemType problemType) {
            this.problemType = problemType;
            this.__explicitlySet__.add("problemType");
            return this;
        }

        public Builder referenceCount(Integer referenceCount) {
            this.referenceCount = referenceCount;
            this.__explicitlySet__.add("referenceCount");
            return this;
        }

        public SqlTuningAdvisorTaskSummaryReportObjectStatFindingSummary build() {
            SqlTuningAdvisorTaskSummaryReportObjectStatFindingSummary model = new SqlTuningAdvisorTaskSummaryReportObjectStatFindingSummary(this.objectHashValue, this.objectName, this.objectType, this.schema, this.problemType, this.referenceCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlTuningAdvisorTaskSummaryReportObjectStatFindingSummary model) {
            if (model.wasPropertyExplicitlySet("objectHashValue")) {
                this.objectHashValue(model.getObjectHashValue());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            if (model.wasPropertyExplicitlySet("schema")) {
                this.schema(model.getSchema());
            }
            if (model.wasPropertyExplicitlySet("problemType")) {
                this.problemType(model.getProblemType());
            }
            if (model.wasPropertyExplicitlySet("referenceCount")) {
                this.referenceCount(model.getReferenceCount());
            }
            return this;
        }
    }
}

