/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProxiedForUserSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="authentication")
    private final Authentication authentication;
    @JsonProperty(value="flags")
    private final Flags flags;

    @Deprecated
    @ConstructorProperties(value={"name", "authentication", "flags"})
    public ProxiedForUserSummary(String name, Authentication authentication, Flags flags) {
        this.name = name;
        this.authentication = authentication;
        this.flags = flags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProxiedForUserSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", authentication=").append(String.valueOf((Object)this.authentication));
        sb.append(", flags=").append(String.valueOf((Object)this.flags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProxiedForUserSummary)) {
            return false;
        }
        ProxiedForUserSummary other = (ProxiedForUserSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.authentication, (Object)other.authentication) && Objects.equals((Object)this.flags, (Object)other.flags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.authentication == null ? 43 : this.authentication.hashCode());
        result = result * 59 + (this.flags == null ? 43 : this.flags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Flags implements BmcEnum
    {
        ProxyMayActivateAllClientRoles("PROXY_MAY_ACTIVATE_ALL_CLIENT_ROLES"),
        NoClientRolesMayBeActivated("NO_CLIENT_ROLES_MAY_BE_ACTIVATED"),
        ProxyMayActivateRole("PROXY_MAY_ACTIVATE_ROLE"),
        ProxyMayNotActivateRole("PROXY_MAY_NOT_ACTIVATE_ROLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Flags> map;

        private Flags(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Flags create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Flags', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Flags.class);
            map = new HashMap<String, Flags>();
            for (Flags v : Flags.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Authentication implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Authentication> map;

        private Authentication(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Authentication create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Authentication', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Authentication.class);
            map = new HashMap<String, Authentication>();
            for (Authentication v : Authentication.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="authentication")
        private Authentication authentication;
        @JsonProperty(value="flags")
        private Flags flags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder authentication(Authentication authentication) {
            this.authentication = authentication;
            this.__explicitlySet__.add("authentication");
            return this;
        }

        public Builder flags(Flags flags) {
            this.flags = flags;
            this.__explicitlySet__.add("flags");
            return this;
        }

        public ProxiedForUserSummary build() {
            ProxiedForUserSummary model = new ProxiedForUserSummary(this.name, this.authentication, this.flags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProxiedForUserSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("authentication")) {
                this.authentication(model.getAuthentication());
            }
            if (model.wasPropertyExplicitlySet("flags")) {
                this.flags(model.getFlags());
            }
            return this;
        }
    }
}

