/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.OptimizerDatabase;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsAdvisorExecutionReport;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OptimizerStatisticsAdvisorExecution
extends ExplicitlySetBmcModel {
    @JsonProperty(value="database")
    private final OptimizerDatabase database;
    @JsonProperty(value="report")
    private final OptimizerStatisticsAdvisorExecutionReport report;
    @JsonProperty(value="taskName")
    private final String taskName;
    @JsonProperty(value="executionName")
    private final String executionName;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="statusMessage")
    private final String statusMessage;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="findings")
    private final Integer findings;

    @Deprecated
    @ConstructorProperties(value={"database", "report", "taskName", "executionName", "timeStart", "timeEnd", "status", "statusMessage", "errorMessage", "findings"})
    public OptimizerStatisticsAdvisorExecution(OptimizerDatabase database, OptimizerStatisticsAdvisorExecutionReport report, String taskName, String executionName, Date timeStart, Date timeEnd, Status status, String statusMessage, String errorMessage, Integer findings) {
        this.database = database;
        this.report = report;
        this.taskName = taskName;
        this.executionName = executionName;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.status = status;
        this.statusMessage = statusMessage;
        this.errorMessage = errorMessage;
        this.findings = findings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OptimizerDatabase getDatabase() {
        return this.database;
    }

    public OptimizerStatisticsAdvisorExecutionReport getReport() {
        return this.report;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getExecutionName() {
        return this.executionName;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Integer getFindings() {
        return this.findings;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OptimizerStatisticsAdvisorExecution(");
        sb.append("super=").append(super.toString());
        sb.append("database=").append(String.valueOf((Object)this.database));
        sb.append(", report=").append(String.valueOf((Object)this.report));
        sb.append(", taskName=").append(String.valueOf(this.taskName));
        sb.append(", executionName=").append(String.valueOf(this.executionName));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", statusMessage=").append(String.valueOf(this.statusMessage));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", findings=").append(String.valueOf(this.findings));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptimizerStatisticsAdvisorExecution)) {
            return false;
        }
        OptimizerStatisticsAdvisorExecution other = (OptimizerStatisticsAdvisorExecution)((Object)o);
        return Objects.equals((Object)this.database, (Object)other.database) && Objects.equals((Object)this.report, (Object)other.report) && Objects.equals(this.taskName, other.taskName) && Objects.equals(this.executionName, other.executionName) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.statusMessage, other.statusMessage) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.findings, other.findings) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.database == null ? 43 : this.database.hashCode());
        result = result * 59 + (this.report == null ? 43 : this.report.hashCode());
        result = result * 59 + (this.taskName == null ? 43 : this.taskName.hashCode());
        result = result * 59 + (this.executionName == null ? 43 : this.executionName.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.statusMessage == null ? 43 : this.statusMessage.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.findings == null ? 43 : this.findings.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Executing("EXECUTING"),
        Completed("COMPLETED"),
        Interrupted("INTERRUPTED"),
        Cancelled("CANCELLED"),
        FatalError("FATAL_ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="database")
        private OptimizerDatabase database;
        @JsonProperty(value="report")
        private OptimizerStatisticsAdvisorExecutionReport report;
        @JsonProperty(value="taskName")
        private String taskName;
        @JsonProperty(value="executionName")
        private String executionName;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="statusMessage")
        private String statusMessage;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="findings")
        private Integer findings;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder database(OptimizerDatabase database) {
            this.database = database;
            this.__explicitlySet__.add("database");
            return this;
        }

        public Builder report(OptimizerStatisticsAdvisorExecutionReport report) {
            this.report = report;
            this.__explicitlySet__.add("report");
            return this;
        }

        public Builder taskName(String taskName) {
            this.taskName = taskName;
            this.__explicitlySet__.add("taskName");
            return this;
        }

        public Builder executionName(String executionName) {
            this.executionName = executionName;
            this.__explicitlySet__.add("executionName");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            this.__explicitlySet__.add("statusMessage");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder findings(Integer findings) {
            this.findings = findings;
            this.__explicitlySet__.add("findings");
            return this;
        }

        public OptimizerStatisticsAdvisorExecution build() {
            OptimizerStatisticsAdvisorExecution model = new OptimizerStatisticsAdvisorExecution(this.database, this.report, this.taskName, this.executionName, this.timeStart, this.timeEnd, this.status, this.statusMessage, this.errorMessage, this.findings);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OptimizerStatisticsAdvisorExecution model) {
            if (model.wasPropertyExplicitlySet("database")) {
                this.database(model.getDatabase());
            }
            if (model.wasPropertyExplicitlySet("report")) {
                this.report(model.getReport());
            }
            if (model.wasPropertyExplicitlySet("taskName")) {
                this.taskName(model.getTaskName());
            }
            if (model.wasPropertyExplicitlySet("executionName")) {
                this.executionName(model.getExecutionName());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("statusMessage")) {
                this.statusMessage(model.getStatusMessage());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("findings")) {
                this.findings(model.getFindings());
            }
            return this;
        }
    }
}

