/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseSubType;
import com.oracle.bmc.databasemanagement.model.DatabaseType;
import com.oracle.bmc.databasemanagement.model.DeploymentType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OptimizerDatabase
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="dbType")
    private final DatabaseType dbType;
    @JsonProperty(value="dbSubType")
    private final DatabaseSubType dbSubType;
    @JsonProperty(value="dbDeploymentType")
    private final DeploymentType dbDeploymentType;
    @JsonProperty(value="dbVersion")
    private final String dbVersion;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "dbType", "dbSubType", "dbDeploymentType", "dbVersion", "compartmentId"})
    public OptimizerDatabase(String id, String name, DatabaseType dbType, DatabaseSubType dbSubType, DeploymentType dbDeploymentType, String dbVersion, String compartmentId) {
        this.id = id;
        this.name = name;
        this.dbType = dbType;
        this.dbSubType = dbSubType;
        this.dbDeploymentType = dbDeploymentType;
        this.dbVersion = dbVersion;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseType getDbType() {
        return this.dbType;
    }

    public DatabaseSubType getDbSubType() {
        return this.dbSubType;
    }

    public DeploymentType getDbDeploymentType() {
        return this.dbDeploymentType;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OptimizerDatabase(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", dbType=").append(String.valueOf((Object)this.dbType));
        sb.append(", dbSubType=").append(String.valueOf((Object)this.dbSubType));
        sb.append(", dbDeploymentType=").append(String.valueOf((Object)this.dbDeploymentType));
        sb.append(", dbVersion=").append(String.valueOf(this.dbVersion));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptimizerDatabase)) {
            return false;
        }
        OptimizerDatabase other = (OptimizerDatabase)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.dbType, (Object)other.dbType) && Objects.equals((Object)this.dbSubType, (Object)other.dbSubType) && Objects.equals((Object)this.dbDeploymentType, (Object)other.dbDeploymentType) && Objects.equals(this.dbVersion, other.dbVersion) && Objects.equals(this.compartmentId, other.compartmentId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.dbType == null ? 43 : this.dbType.hashCode());
        result = result * 59 + (this.dbSubType == null ? 43 : this.dbSubType.hashCode());
        result = result * 59 + (this.dbDeploymentType == null ? 43 : this.dbDeploymentType.hashCode());
        result = result * 59 + (this.dbVersion == null ? 43 : this.dbVersion.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="dbType")
        private DatabaseType dbType;
        @JsonProperty(value="dbSubType")
        private DatabaseSubType dbSubType;
        @JsonProperty(value="dbDeploymentType")
        private DeploymentType dbDeploymentType;
        @JsonProperty(value="dbVersion")
        private String dbVersion;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder dbType(DatabaseType dbType) {
            this.dbType = dbType;
            this.__explicitlySet__.add("dbType");
            return this;
        }

        public Builder dbSubType(DatabaseSubType dbSubType) {
            this.dbSubType = dbSubType;
            this.__explicitlySet__.add("dbSubType");
            return this;
        }

        public Builder dbDeploymentType(DeploymentType dbDeploymentType) {
            this.dbDeploymentType = dbDeploymentType;
            this.__explicitlySet__.add("dbDeploymentType");
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            this.__explicitlySet__.add("dbVersion");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public OptimizerDatabase build() {
            OptimizerDatabase model = new OptimizerDatabase(this.id, this.name, this.dbType, this.dbSubType, this.dbDeploymentType, this.dbVersion, this.compartmentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OptimizerDatabase model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("dbType")) {
                this.dbType(model.getDbType());
            }
            if (model.wasPropertyExplicitlySet("dbSubType")) {
                this.dbSubType(model.getDbSubType());
            }
            if (model.wasPropertyExplicitlySet("dbDeploymentType")) {
                this.dbDeploymentType(model.getDbDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("dbVersion")) {
                this.dbVersion(model.getDbVersion());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            return this;
        }
    }
}

