/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseSubType;
import com.oracle.bmc.databasemanagement.model.DatabaseType;
import com.oracle.bmc.databasemanagement.model.DeploymentType;
import com.oracle.bmc.databasemanagement.model.WorkloadType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobDatabase
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="databaseType")
    private final DatabaseType databaseType;
    @JsonProperty(value="databaseSubType")
    private final DatabaseSubType databaseSubType;
    @JsonProperty(value="deploymentType")
    private final DeploymentType deploymentType;
    @JsonProperty(value="isCluster")
    private final Boolean isCluster;
    @JsonProperty(value="workloadType")
    private final WorkloadType workloadType;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "databaseType", "databaseSubType", "deploymentType", "isCluster", "workloadType"})
    public JobDatabase(String id, String name, DatabaseType databaseType, DatabaseSubType databaseSubType, DeploymentType deploymentType, Boolean isCluster, WorkloadType workloadType) {
        this.id = id;
        this.name = name;
        this.databaseType = databaseType;
        this.databaseSubType = databaseSubType;
        this.deploymentType = deploymentType;
        this.isCluster = isCluster;
        this.workloadType = workloadType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public DatabaseSubType getDatabaseSubType() {
        return this.databaseSubType;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public Boolean getIsCluster() {
        return this.isCluster;
    }

    public WorkloadType getWorkloadType() {
        return this.workloadType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobDatabase(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", databaseType=").append(String.valueOf((Object)this.databaseType));
        sb.append(", databaseSubType=").append(String.valueOf((Object)this.databaseSubType));
        sb.append(", deploymentType=").append(String.valueOf((Object)this.deploymentType));
        sb.append(", isCluster=").append(String.valueOf(this.isCluster));
        sb.append(", workloadType=").append(String.valueOf((Object)this.workloadType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobDatabase)) {
            return false;
        }
        JobDatabase other = (JobDatabase)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.databaseType, (Object)other.databaseType) && Objects.equals((Object)this.databaseSubType, (Object)other.databaseSubType) && Objects.equals((Object)this.deploymentType, (Object)other.deploymentType) && Objects.equals(this.isCluster, other.isCluster) && Objects.equals((Object)this.workloadType, (Object)other.workloadType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.databaseSubType == null ? 43 : this.databaseSubType.hashCode());
        result = result * 59 + (this.deploymentType == null ? 43 : this.deploymentType.hashCode());
        result = result * 59 + (this.isCluster == null ? 43 : this.isCluster.hashCode());
        result = result * 59 + (this.workloadType == null ? 43 : this.workloadType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="databaseType")
        private DatabaseType databaseType;
        @JsonProperty(value="databaseSubType")
        private DatabaseSubType databaseSubType;
        @JsonProperty(value="deploymentType")
        private DeploymentType deploymentType;
        @JsonProperty(value="isCluster")
        private Boolean isCluster;
        @JsonProperty(value="workloadType")
        private WorkloadType workloadType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder databaseType(DatabaseType databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder databaseSubType(DatabaseSubType databaseSubType) {
            this.databaseSubType = databaseSubType;
            this.__explicitlySet__.add("databaseSubType");
            return this;
        }

        public Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            this.__explicitlySet__.add("deploymentType");
            return this;
        }

        public Builder isCluster(Boolean isCluster) {
            this.isCluster = isCluster;
            this.__explicitlySet__.add("isCluster");
            return this;
        }

        public Builder workloadType(WorkloadType workloadType) {
            this.workloadType = workloadType;
            this.__explicitlySet__.add("workloadType");
            return this;
        }

        public JobDatabase build() {
            JobDatabase model = new JobDatabase(this.id, this.name, this.databaseType, this.databaseSubType, this.deploymentType, this.isCluster, this.workloadType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JobDatabase model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("databaseSubType")) {
                this.databaseSubType(model.getDatabaseSubType());
            }
            if (model.wasPropertyExplicitlySet("deploymentType")) {
                this.deploymentType(model.getDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("isCluster")) {
                this.isCluster(model.getIsCluster());
            }
            if (model.wasPropertyExplicitlySet("workloadType")) {
                this.workloadType(model.getWorkloadType());
            }
            return this;
        }
    }
}

