/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseSubType;
import com.oracle.bmc.databasemanagement.model.DatabaseType;
import com.oracle.bmc.databasemanagement.model.DeploymentType;
import com.oracle.bmc.databasemanagement.model.FleetMetricDefinition;
import com.oracle.bmc.databasemanagement.model.WorkloadType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseUsageMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dbId")
    private final String dbId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="databaseType")
    private final DatabaseType databaseType;
    @JsonProperty(value="databaseSubType")
    private final DatabaseSubType databaseSubType;
    @JsonProperty(value="deploymentType")
    private final DeploymentType deploymentType;
    @JsonProperty(value="databaseVersion")
    private final String databaseVersion;
    @JsonProperty(value="workloadType")
    private final WorkloadType workloadType;
    @JsonProperty(value="databaseName")
    private final String databaseName;
    @JsonProperty(value="databaseContainerId")
    private final String databaseContainerId;
    @JsonProperty(value="metrics")
    private final List<FleetMetricDefinition> metrics;

    @Deprecated
    @ConstructorProperties(value={"dbId", "compartmentId", "databaseType", "databaseSubType", "deploymentType", "databaseVersion", "workloadType", "databaseName", "databaseContainerId", "metrics"})
    public DatabaseUsageMetrics(String dbId, String compartmentId, DatabaseType databaseType, DatabaseSubType databaseSubType, DeploymentType deploymentType, String databaseVersion, WorkloadType workloadType, String databaseName, String databaseContainerId, List<FleetMetricDefinition> metrics) {
        this.dbId = dbId;
        this.compartmentId = compartmentId;
        this.databaseType = databaseType;
        this.databaseSubType = databaseSubType;
        this.deploymentType = deploymentType;
        this.databaseVersion = databaseVersion;
        this.workloadType = workloadType;
        this.databaseName = databaseName;
        this.databaseContainerId = databaseContainerId;
        this.metrics = metrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDbId() {
        return this.dbId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public DatabaseSubType getDatabaseSubType() {
        return this.databaseSubType;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public WorkloadType getWorkloadType() {
        return this.workloadType;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseContainerId() {
        return this.databaseContainerId;
    }

    public List<FleetMetricDefinition> getMetrics() {
        return this.metrics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseUsageMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("dbId=").append(String.valueOf(this.dbId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", databaseType=").append(String.valueOf((Object)this.databaseType));
        sb.append(", databaseSubType=").append(String.valueOf((Object)this.databaseSubType));
        sb.append(", deploymentType=").append(String.valueOf((Object)this.deploymentType));
        sb.append(", databaseVersion=").append(String.valueOf(this.databaseVersion));
        sb.append(", workloadType=").append(String.valueOf((Object)this.workloadType));
        sb.append(", databaseName=").append(String.valueOf(this.databaseName));
        sb.append(", databaseContainerId=").append(String.valueOf(this.databaseContainerId));
        sb.append(", metrics=").append(String.valueOf(this.metrics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseUsageMetrics)) {
            return false;
        }
        DatabaseUsageMetrics other = (DatabaseUsageMetrics)((Object)o);
        return Objects.equals(this.dbId, other.dbId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.databaseType, (Object)other.databaseType) && Objects.equals((Object)this.databaseSubType, (Object)other.databaseSubType) && Objects.equals((Object)this.deploymentType, (Object)other.deploymentType) && Objects.equals(this.databaseVersion, other.databaseVersion) && Objects.equals((Object)this.workloadType, (Object)other.workloadType) && Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.databaseContainerId, other.databaseContainerId) && Objects.equals(this.metrics, other.metrics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dbId == null ? 43 : this.dbId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.databaseSubType == null ? 43 : this.databaseSubType.hashCode());
        result = result * 59 + (this.deploymentType == null ? 43 : this.deploymentType.hashCode());
        result = result * 59 + (this.databaseVersion == null ? 43 : this.databaseVersion.hashCode());
        result = result * 59 + (this.workloadType == null ? 43 : this.workloadType.hashCode());
        result = result * 59 + (this.databaseName == null ? 43 : this.databaseName.hashCode());
        result = result * 59 + (this.databaseContainerId == null ? 43 : this.databaseContainerId.hashCode());
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dbId")
        private String dbId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="databaseType")
        private DatabaseType databaseType;
        @JsonProperty(value="databaseSubType")
        private DatabaseSubType databaseSubType;
        @JsonProperty(value="deploymentType")
        private DeploymentType deploymentType;
        @JsonProperty(value="databaseVersion")
        private String databaseVersion;
        @JsonProperty(value="workloadType")
        private WorkloadType workloadType;
        @JsonProperty(value="databaseName")
        private String databaseName;
        @JsonProperty(value="databaseContainerId")
        private String databaseContainerId;
        @JsonProperty(value="metrics")
        private List<FleetMetricDefinition> metrics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dbId(String dbId) {
            this.dbId = dbId;
            this.__explicitlySet__.add("dbId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder databaseType(DatabaseType databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder databaseSubType(DatabaseSubType databaseSubType) {
            this.databaseSubType = databaseSubType;
            this.__explicitlySet__.add("databaseSubType");
            return this;
        }

        public Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            this.__explicitlySet__.add("deploymentType");
            return this;
        }

        public Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            this.__explicitlySet__.add("databaseVersion");
            return this;
        }

        public Builder workloadType(WorkloadType workloadType) {
            this.workloadType = workloadType;
            this.__explicitlySet__.add("workloadType");
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            this.__explicitlySet__.add("databaseName");
            return this;
        }

        public Builder databaseContainerId(String databaseContainerId) {
            this.databaseContainerId = databaseContainerId;
            this.__explicitlySet__.add("databaseContainerId");
            return this;
        }

        public Builder metrics(List<FleetMetricDefinition> metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public DatabaseUsageMetrics build() {
            DatabaseUsageMetrics model = new DatabaseUsageMetrics(this.dbId, this.compartmentId, this.databaseType, this.databaseSubType, this.deploymentType, this.databaseVersion, this.workloadType, this.databaseName, this.databaseContainerId, this.metrics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseUsageMetrics model) {
            if (model.wasPropertyExplicitlySet("dbId")) {
                this.dbId(model.getDbId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("databaseSubType")) {
                this.databaseSubType(model.getDatabaseSubType());
            }
            if (model.wasPropertyExplicitlySet("deploymentType")) {
                this.deploymentType(model.getDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("databaseVersion")) {
                this.databaseVersion(model.getDatabaseVersion());
            }
            if (model.wasPropertyExplicitlySet("workloadType")) {
                this.workloadType(model.getWorkloadType());
            }
            if (model.wasPropertyExplicitlySet("databaseName")) {
                this.databaseName(model.getDatabaseName());
            }
            if (model.wasPropertyExplicitlySet("databaseContainerId")) {
                this.databaseContainerId(model.getDatabaseContainerId());
            }
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            return this;
        }
    }
}

