/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseParameterSummary;
import com.oracle.bmc.databasemanagement.model.DatabaseSubType;
import com.oracle.bmc.databasemanagement.model.DatabaseType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseParametersCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="databaseName")
    private final String databaseName;
    @JsonProperty(value="databaseType")
    private final DatabaseType databaseType;
    @JsonProperty(value="databaseSubType")
    private final DatabaseSubType databaseSubType;
    @JsonProperty(value="databaseVersion")
    private final String databaseVersion;
    @JsonProperty(value="items")
    private final List<DatabaseParameterSummary> items;

    @Deprecated
    @ConstructorProperties(value={"databaseName", "databaseType", "databaseSubType", "databaseVersion", "items"})
    public DatabaseParametersCollection(String databaseName, DatabaseType databaseType, DatabaseSubType databaseSubType, String databaseVersion, List<DatabaseParameterSummary> items) {
        this.databaseName = databaseName;
        this.databaseType = databaseType;
        this.databaseSubType = databaseSubType;
        this.databaseVersion = databaseVersion;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public DatabaseSubType getDatabaseSubType() {
        return this.databaseSubType;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public List<DatabaseParameterSummary> getItems() {
        return this.items;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseParametersCollection(");
        sb.append("super=").append(super.toString());
        sb.append("databaseName=").append(String.valueOf(this.databaseName));
        sb.append(", databaseType=").append(String.valueOf((Object)this.databaseType));
        sb.append(", databaseSubType=").append(String.valueOf((Object)this.databaseSubType));
        sb.append(", databaseVersion=").append(String.valueOf(this.databaseVersion));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseParametersCollection)) {
            return false;
        }
        DatabaseParametersCollection other = (DatabaseParametersCollection)((Object)o);
        return Objects.equals(this.databaseName, other.databaseName) && Objects.equals((Object)this.databaseType, (Object)other.databaseType) && Objects.equals((Object)this.databaseSubType, (Object)other.databaseSubType) && Objects.equals(this.databaseVersion, other.databaseVersion) && Objects.equals(this.items, other.items) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.databaseName == null ? 43 : this.databaseName.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.databaseSubType == null ? 43 : this.databaseSubType.hashCode());
        result = result * 59 + (this.databaseVersion == null ? 43 : this.databaseVersion.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseName")
        private String databaseName;
        @JsonProperty(value="databaseType")
        private DatabaseType databaseType;
        @JsonProperty(value="databaseSubType")
        private DatabaseSubType databaseSubType;
        @JsonProperty(value="databaseVersion")
        private String databaseVersion;
        @JsonProperty(value="items")
        private List<DatabaseParameterSummary> items;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            this.__explicitlySet__.add("databaseName");
            return this;
        }

        public Builder databaseType(DatabaseType databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder databaseSubType(DatabaseSubType databaseSubType) {
            this.databaseSubType = databaseSubType;
            this.__explicitlySet__.add("databaseSubType");
            return this;
        }

        public Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            this.__explicitlySet__.add("databaseVersion");
            return this;
        }

        public Builder items(List<DatabaseParameterSummary> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public DatabaseParametersCollection build() {
            DatabaseParametersCollection model = new DatabaseParametersCollection(this.databaseName, this.databaseType, this.databaseSubType, this.databaseVersion, this.items);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseParametersCollection model) {
            if (model.wasPropertyExplicitlySet("databaseName")) {
                this.databaseName(model.getDatabaseName());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("databaseSubType")) {
                this.databaseSubType(model.getDatabaseSubType());
            }
            if (model.wasPropertyExplicitlySet("databaseVersion")) {
                this.databaseVersion(model.getDatabaseVersion());
            }
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            return this;
        }
    }
}

