/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ActivityTimeSeriesMetrics;
import com.oracle.bmc.databasemanagement.model.CpuUtilizationAggregateMetrics;
import com.oracle.bmc.databasemanagement.model.DatabaseIOAggregateMetrics;
import com.oracle.bmc.databasemanagement.model.DatabaseTimeAggregateMetrics;
import com.oracle.bmc.databasemanagement.model.MemoryAggregateMetrics;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseInstanceHomeMetricsDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="instanceName")
    private final String instanceName;
    @JsonProperty(value="instanceNumber")
    private final Integer instanceNumber;
    @JsonProperty(value="activityTimeSeriesMetrics")
    private final List<ActivityTimeSeriesMetrics> activityTimeSeriesMetrics;
    @JsonProperty(value="dbTimeAggregateMetrics")
    private final DatabaseTimeAggregateMetrics dbTimeAggregateMetrics;
    @JsonProperty(value="ioAggregateMetrics")
    private final DatabaseIOAggregateMetrics ioAggregateMetrics;
    @JsonProperty(value="memoryAggregateMetrics")
    private final MemoryAggregateMetrics memoryAggregateMetrics;
    @JsonProperty(value="cpuUtilizationAggregateMetrics")
    private final CpuUtilizationAggregateMetrics cpuUtilizationAggregateMetrics;

    @Deprecated
    @ConstructorProperties(value={"instanceName", "instanceNumber", "activityTimeSeriesMetrics", "dbTimeAggregateMetrics", "ioAggregateMetrics", "memoryAggregateMetrics", "cpuUtilizationAggregateMetrics"})
    public DatabaseInstanceHomeMetricsDefinition(String instanceName, Integer instanceNumber, List<ActivityTimeSeriesMetrics> activityTimeSeriesMetrics, DatabaseTimeAggregateMetrics dbTimeAggregateMetrics, DatabaseIOAggregateMetrics ioAggregateMetrics, MemoryAggregateMetrics memoryAggregateMetrics, CpuUtilizationAggregateMetrics cpuUtilizationAggregateMetrics) {
        this.instanceName = instanceName;
        this.instanceNumber = instanceNumber;
        this.activityTimeSeriesMetrics = activityTimeSeriesMetrics;
        this.dbTimeAggregateMetrics = dbTimeAggregateMetrics;
        this.ioAggregateMetrics = ioAggregateMetrics;
        this.memoryAggregateMetrics = memoryAggregateMetrics;
        this.cpuUtilizationAggregateMetrics = cpuUtilizationAggregateMetrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Integer getInstanceNumber() {
        return this.instanceNumber;
    }

    public List<ActivityTimeSeriesMetrics> getActivityTimeSeriesMetrics() {
        return this.activityTimeSeriesMetrics;
    }

    public DatabaseTimeAggregateMetrics getDbTimeAggregateMetrics() {
        return this.dbTimeAggregateMetrics;
    }

    public DatabaseIOAggregateMetrics getIoAggregateMetrics() {
        return this.ioAggregateMetrics;
    }

    public MemoryAggregateMetrics getMemoryAggregateMetrics() {
        return this.memoryAggregateMetrics;
    }

    public CpuUtilizationAggregateMetrics getCpuUtilizationAggregateMetrics() {
        return this.cpuUtilizationAggregateMetrics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseInstanceHomeMetricsDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("instanceName=").append(String.valueOf(this.instanceName));
        sb.append(", instanceNumber=").append(String.valueOf(this.instanceNumber));
        sb.append(", activityTimeSeriesMetrics=").append(String.valueOf(this.activityTimeSeriesMetrics));
        sb.append(", dbTimeAggregateMetrics=").append(String.valueOf((Object)this.dbTimeAggregateMetrics));
        sb.append(", ioAggregateMetrics=").append(String.valueOf((Object)this.ioAggregateMetrics));
        sb.append(", memoryAggregateMetrics=").append(String.valueOf((Object)this.memoryAggregateMetrics));
        sb.append(", cpuUtilizationAggregateMetrics=").append(String.valueOf((Object)this.cpuUtilizationAggregateMetrics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseInstanceHomeMetricsDefinition)) {
            return false;
        }
        DatabaseInstanceHomeMetricsDefinition other = (DatabaseInstanceHomeMetricsDefinition)((Object)o);
        return Objects.equals(this.instanceName, other.instanceName) && Objects.equals(this.instanceNumber, other.instanceNumber) && Objects.equals(this.activityTimeSeriesMetrics, other.activityTimeSeriesMetrics) && Objects.equals((Object)this.dbTimeAggregateMetrics, (Object)other.dbTimeAggregateMetrics) && Objects.equals((Object)this.ioAggregateMetrics, (Object)other.ioAggregateMetrics) && Objects.equals((Object)this.memoryAggregateMetrics, (Object)other.memoryAggregateMetrics) && Objects.equals((Object)this.cpuUtilizationAggregateMetrics, (Object)other.cpuUtilizationAggregateMetrics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.instanceName == null ? 43 : this.instanceName.hashCode());
        result = result * 59 + (this.instanceNumber == null ? 43 : this.instanceNumber.hashCode());
        result = result * 59 + (this.activityTimeSeriesMetrics == null ? 43 : this.activityTimeSeriesMetrics.hashCode());
        result = result * 59 + (this.dbTimeAggregateMetrics == null ? 43 : this.dbTimeAggregateMetrics.hashCode());
        result = result * 59 + (this.ioAggregateMetrics == null ? 43 : this.ioAggregateMetrics.hashCode());
        result = result * 59 + (this.memoryAggregateMetrics == null ? 43 : this.memoryAggregateMetrics.hashCode());
        result = result * 59 + (this.cpuUtilizationAggregateMetrics == null ? 43 : this.cpuUtilizationAggregateMetrics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="instanceNumber")
        private Integer instanceNumber;
        @JsonProperty(value="activityTimeSeriesMetrics")
        private List<ActivityTimeSeriesMetrics> activityTimeSeriesMetrics;
        @JsonProperty(value="dbTimeAggregateMetrics")
        private DatabaseTimeAggregateMetrics dbTimeAggregateMetrics;
        @JsonProperty(value="ioAggregateMetrics")
        private DatabaseIOAggregateMetrics ioAggregateMetrics;
        @JsonProperty(value="memoryAggregateMetrics")
        private MemoryAggregateMetrics memoryAggregateMetrics;
        @JsonProperty(value="cpuUtilizationAggregateMetrics")
        private CpuUtilizationAggregateMetrics cpuUtilizationAggregateMetrics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            this.__explicitlySet__.add("instanceName");
            return this;
        }

        public Builder instanceNumber(Integer instanceNumber) {
            this.instanceNumber = instanceNumber;
            this.__explicitlySet__.add("instanceNumber");
            return this;
        }

        public Builder activityTimeSeriesMetrics(List<ActivityTimeSeriesMetrics> activityTimeSeriesMetrics) {
            this.activityTimeSeriesMetrics = activityTimeSeriesMetrics;
            this.__explicitlySet__.add("activityTimeSeriesMetrics");
            return this;
        }

        public Builder dbTimeAggregateMetrics(DatabaseTimeAggregateMetrics dbTimeAggregateMetrics) {
            this.dbTimeAggregateMetrics = dbTimeAggregateMetrics;
            this.__explicitlySet__.add("dbTimeAggregateMetrics");
            return this;
        }

        public Builder ioAggregateMetrics(DatabaseIOAggregateMetrics ioAggregateMetrics) {
            this.ioAggregateMetrics = ioAggregateMetrics;
            this.__explicitlySet__.add("ioAggregateMetrics");
            return this;
        }

        public Builder memoryAggregateMetrics(MemoryAggregateMetrics memoryAggregateMetrics) {
            this.memoryAggregateMetrics = memoryAggregateMetrics;
            this.__explicitlySet__.add("memoryAggregateMetrics");
            return this;
        }

        public Builder cpuUtilizationAggregateMetrics(CpuUtilizationAggregateMetrics cpuUtilizationAggregateMetrics) {
            this.cpuUtilizationAggregateMetrics = cpuUtilizationAggregateMetrics;
            this.__explicitlySet__.add("cpuUtilizationAggregateMetrics");
            return this;
        }

        public DatabaseInstanceHomeMetricsDefinition build() {
            DatabaseInstanceHomeMetricsDefinition model = new DatabaseInstanceHomeMetricsDefinition(this.instanceName, this.instanceNumber, this.activityTimeSeriesMetrics, this.dbTimeAggregateMetrics, this.ioAggregateMetrics, this.memoryAggregateMetrics, this.cpuUtilizationAggregateMetrics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseInstanceHomeMetricsDefinition model) {
            if (model.wasPropertyExplicitlySet("instanceName")) {
                this.instanceName(model.getInstanceName());
            }
            if (model.wasPropertyExplicitlySet("instanceNumber")) {
                this.instanceNumber(model.getInstanceNumber());
            }
            if (model.wasPropertyExplicitlySet("activityTimeSeriesMetrics")) {
                this.activityTimeSeriesMetrics(model.getActivityTimeSeriesMetrics());
            }
            if (model.wasPropertyExplicitlySet("dbTimeAggregateMetrics")) {
                this.dbTimeAggregateMetrics(model.getDbTimeAggregateMetrics());
            }
            if (model.wasPropertyExplicitlySet("ioAggregateMetrics")) {
                this.ioAggregateMetrics(model.getIoAggregateMetrics());
            }
            if (model.wasPropertyExplicitlySet("memoryAggregateMetrics")) {
                this.memoryAggregateMetrics(model.getMemoryAggregateMetrics());
            }
            if (model.wasPropertyExplicitlySet("cpuUtilizationAggregateMetrics")) {
                this.cpuUtilizationAggregateMetrics(model.getCpuUtilizationAggregateMetrics());
            }
            return this;
        }
    }
}

