/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.MetricDataPoint;
import com.oracle.bmc.databasemanagement.model.MetricStatisticsDefinition;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseIOAggregateMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="iops")
    private final List<MetricDataPoint> iops;
    @JsonProperty(value="ioThroughput")
    private final List<MetricDataPoint> ioThroughput;
    @JsonProperty(value="iopsStatistics")
    private final List<MetricStatisticsDefinition> iopsStatistics;
    @JsonProperty(value="ioThroughputStatistics")
    private final List<MetricStatisticsDefinition> ioThroughputStatistics;

    @Deprecated
    @ConstructorProperties(value={"iops", "ioThroughput", "iopsStatistics", "ioThroughputStatistics"})
    public DatabaseIOAggregateMetrics(List<MetricDataPoint> iops, List<MetricDataPoint> ioThroughput, List<MetricStatisticsDefinition> iopsStatistics, List<MetricStatisticsDefinition> ioThroughputStatistics) {
        this.iops = iops;
        this.ioThroughput = ioThroughput;
        this.iopsStatistics = iopsStatistics;
        this.ioThroughputStatistics = ioThroughputStatistics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<MetricDataPoint> getIops() {
        return this.iops;
    }

    public List<MetricDataPoint> getIoThroughput() {
        return this.ioThroughput;
    }

    public List<MetricStatisticsDefinition> getIopsStatistics() {
        return this.iopsStatistics;
    }

    public List<MetricStatisticsDefinition> getIoThroughputStatistics() {
        return this.ioThroughputStatistics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseIOAggregateMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("iops=").append(String.valueOf(this.iops));
        sb.append(", ioThroughput=").append(String.valueOf(this.ioThroughput));
        sb.append(", iopsStatistics=").append(String.valueOf(this.iopsStatistics));
        sb.append(", ioThroughputStatistics=").append(String.valueOf(this.ioThroughputStatistics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseIOAggregateMetrics)) {
            return false;
        }
        DatabaseIOAggregateMetrics other = (DatabaseIOAggregateMetrics)((Object)o);
        return Objects.equals(this.iops, other.iops) && Objects.equals(this.ioThroughput, other.ioThroughput) && Objects.equals(this.iopsStatistics, other.iopsStatistics) && Objects.equals(this.ioThroughputStatistics, other.ioThroughputStatistics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.iops == null ? 43 : this.iops.hashCode());
        result = result * 59 + (this.ioThroughput == null ? 43 : this.ioThroughput.hashCode());
        result = result * 59 + (this.iopsStatistics == null ? 43 : this.iopsStatistics.hashCode());
        result = result * 59 + (this.ioThroughputStatistics == null ? 43 : this.ioThroughputStatistics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="iops")
        private List<MetricDataPoint> iops;
        @JsonProperty(value="ioThroughput")
        private List<MetricDataPoint> ioThroughput;
        @JsonProperty(value="iopsStatistics")
        private List<MetricStatisticsDefinition> iopsStatistics;
        @JsonProperty(value="ioThroughputStatistics")
        private List<MetricStatisticsDefinition> ioThroughputStatistics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder iops(List<MetricDataPoint> iops) {
            this.iops = iops;
            this.__explicitlySet__.add("iops");
            return this;
        }

        public Builder ioThroughput(List<MetricDataPoint> ioThroughput) {
            this.ioThroughput = ioThroughput;
            this.__explicitlySet__.add("ioThroughput");
            return this;
        }

        public Builder iopsStatistics(List<MetricStatisticsDefinition> iopsStatistics) {
            this.iopsStatistics = iopsStatistics;
            this.__explicitlySet__.add("iopsStatistics");
            return this;
        }

        public Builder ioThroughputStatistics(List<MetricStatisticsDefinition> ioThroughputStatistics) {
            this.ioThroughputStatistics = ioThroughputStatistics;
            this.__explicitlySet__.add("ioThroughputStatistics");
            return this;
        }

        public DatabaseIOAggregateMetrics build() {
            DatabaseIOAggregateMetrics model = new DatabaseIOAggregateMetrics(this.iops, this.ioThroughput, this.iopsStatistics, this.ioThroughputStatistics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseIOAggregateMetrics model) {
            if (model.wasPropertyExplicitlySet("iops")) {
                this.iops(model.getIops());
            }
            if (model.wasPropertyExplicitlySet("ioThroughput")) {
                this.ioThroughput(model.getIoThroughput());
            }
            if (model.wasPropertyExplicitlySet("iopsStatistics")) {
                this.iopsStatistics(model.getIopsStatistics());
            }
            if (model.wasPropertyExplicitlySet("ioThroughputStatistics")) {
                this.ioThroughputStatistics(model.getIoThroughputStatistics());
            }
            return this;
        }
    }
}

