/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConsumerGroupPrivilegeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="grantOption")
    private final GrantOption grantOption;
    @JsonProperty(value="initialGroup")
    private final InitialGroup initialGroup;

    @Deprecated
    @ConstructorProperties(value={"name", "grantOption", "initialGroup"})
    public ConsumerGroupPrivilegeSummary(String name, GrantOption grantOption, InitialGroup initialGroup) {
        this.name = name;
        this.grantOption = grantOption;
        this.initialGroup = initialGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public GrantOption getGrantOption() {
        return this.grantOption;
    }

    public InitialGroup getInitialGroup() {
        return this.initialGroup;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConsumerGroupPrivilegeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", grantOption=").append(String.valueOf((Object)this.grantOption));
        sb.append(", initialGroup=").append(String.valueOf((Object)this.initialGroup));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConsumerGroupPrivilegeSummary)) {
            return false;
        }
        ConsumerGroupPrivilegeSummary other = (ConsumerGroupPrivilegeSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.grantOption, (Object)other.grantOption) && Objects.equals((Object)this.initialGroup, (Object)other.initialGroup) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.grantOption == null ? 43 : this.grantOption.hashCode());
        result = result * 59 + (this.initialGroup == null ? 43 : this.initialGroup.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum InitialGroup implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, InitialGroup> map;

        private InitialGroup(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InitialGroup create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'InitialGroup', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(InitialGroup.class);
            map = new HashMap<String, InitialGroup>();
            for (InitialGroup v : InitialGroup.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum GrantOption implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, GrantOption> map;

        private GrantOption(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GrantOption create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'GrantOption', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(GrantOption.class);
            map = new HashMap<String, GrantOption>();
            for (GrantOption v : GrantOption.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="grantOption")
        private GrantOption grantOption;
        @JsonProperty(value="initialGroup")
        private InitialGroup initialGroup;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder grantOption(GrantOption grantOption) {
            this.grantOption = grantOption;
            this.__explicitlySet__.add("grantOption");
            return this;
        }

        public Builder initialGroup(InitialGroup initialGroup) {
            this.initialGroup = initialGroup;
            this.__explicitlySet__.add("initialGroup");
            return this;
        }

        public ConsumerGroupPrivilegeSummary build() {
            ConsumerGroupPrivilegeSummary model = new ConsumerGroupPrivilegeSummary(this.name, this.grantOption, this.initialGroup);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConsumerGroupPrivilegeSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("grantOption")) {
                this.grantOption(model.getGrantOption());
            }
            if (model.wasPropertyExplicitlySet("initialGroup")) {
                this.initialGroup(model.getInitialGroup());
            }
            return this;
        }
    }
}

