/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.PreferredCredential;
import com.oracle.bmc.databasemanagement.model.PreferredCredentialStatus;
import com.oracle.bmc.databasemanagement.model.Role;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class BasicPreferredCredential
extends PreferredCredential {
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="passwordSecretId")
    private final String passwordSecretId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BasicPreferredCredential(String credentialName, PreferredCredentialStatus status, Boolean isAccessible, String userName, Role role, String passwordSecretId) {
        super(credentialName, status, isAccessible);
        this.userName = userName;
        this.role = role;
        this.passwordSecretId = passwordSecretId;
    }

    public String getUserName() {
        return this.userName;
    }

    public Role getRole() {
        return this.role;
    }

    public String getPasswordSecretId() {
        return this.passwordSecretId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BasicPreferredCredential(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(", passwordSecretId=").append(String.valueOf(this.passwordSecretId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicPreferredCredential)) {
            return false;
        }
        BasicPreferredCredential other = (BasicPreferredCredential)((Object)o);
        return Objects.equals(this.userName, other.userName) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.passwordSecretId, other.passwordSecretId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.passwordSecretId == null ? 43 : this.passwordSecretId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="credentialName")
        private String credentialName;
        @JsonProperty(value="status")
        private PreferredCredentialStatus status;
        @JsonProperty(value="isAccessible")
        private Boolean isAccessible;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="passwordSecretId")
        private String passwordSecretId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder credentialName(String credentialName) {
            this.credentialName = credentialName;
            this.__explicitlySet__.add("credentialName");
            return this;
        }

        public Builder status(PreferredCredentialStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder isAccessible(Boolean isAccessible) {
            this.isAccessible = isAccessible;
            this.__explicitlySet__.add("isAccessible");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder passwordSecretId(String passwordSecretId) {
            this.passwordSecretId = passwordSecretId;
            this.__explicitlySet__.add("passwordSecretId");
            return this;
        }

        public BasicPreferredCredential build() {
            BasicPreferredCredential model = new BasicPreferredCredential(this.credentialName, this.status, this.isAccessible, this.userName, this.role, this.passwordSecretId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BasicPreferredCredential model) {
            if (model.wasPropertyExplicitlySet("credentialName")) {
                this.credentialName(model.getCredentialName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("isAccessible")) {
                this.isAccessible(model.getIsAccessible());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("passwordSecretId")) {
                this.passwordSecretId(model.getPasswordSecretId());
            }
            return this;
        }
    }
}

