/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AwrDbWaitEventBucketSummary;
import com.oracle.bmc.databasemanagement.model.AwrQueryResult;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="awrResultType")
@JsonFilter(value="explicitlySetFilter")
public final class AwrDbWaitEventBucketCollection
extends AwrQueryResult {
    @JsonProperty(value="totalWaits")
    private final Long totalWaits;
    @JsonProperty(value="items")
    private final List<AwrDbWaitEventBucketSummary> items;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AwrDbWaitEventBucketCollection(String name, String version, String queryKey, Double dbQueryTimeInSecs, Long totalWaits, List<AwrDbWaitEventBucketSummary> items) {
        super(name, version, queryKey, dbQueryTimeInSecs);
        this.totalWaits = totalWaits;
        this.items = items;
    }

    public Long getTotalWaits() {
        return this.totalWaits;
    }

    public List<AwrDbWaitEventBucketSummary> getItems() {
        return this.items;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AwrDbWaitEventBucketCollection(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", totalWaits=").append(String.valueOf(this.totalWaits));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwrDbWaitEventBucketCollection)) {
            return false;
        }
        AwrDbWaitEventBucketCollection other = (AwrDbWaitEventBucketCollection)((Object)o);
        return Objects.equals(this.totalWaits, other.totalWaits) && Objects.equals(this.items, other.items) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.totalWaits == null ? 43 : this.totalWaits.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="queryKey")
        private String queryKey;
        @JsonProperty(value="dbQueryTimeInSecs")
        private Double dbQueryTimeInSecs;
        @JsonProperty(value="totalWaits")
        private Long totalWaits;
        @JsonProperty(value="items")
        private List<AwrDbWaitEventBucketSummary> items;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder queryKey(String queryKey) {
            this.queryKey = queryKey;
            this.__explicitlySet__.add("queryKey");
            return this;
        }

        public Builder dbQueryTimeInSecs(Double dbQueryTimeInSecs) {
            this.dbQueryTimeInSecs = dbQueryTimeInSecs;
            this.__explicitlySet__.add("dbQueryTimeInSecs");
            return this;
        }

        public Builder totalWaits(Long totalWaits) {
            this.totalWaits = totalWaits;
            this.__explicitlySet__.add("totalWaits");
            return this;
        }

        public Builder items(List<AwrDbWaitEventBucketSummary> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public AwrDbWaitEventBucketCollection build() {
            AwrDbWaitEventBucketCollection model = new AwrDbWaitEventBucketCollection(this.name, this.version, this.queryKey, this.dbQueryTimeInSecs, this.totalWaits, this.items);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AwrDbWaitEventBucketCollection model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("queryKey")) {
                this.queryKey(model.getQueryKey());
            }
            if (model.wasPropertyExplicitlySet("dbQueryTimeInSecs")) {
                this.dbQueryTimeInSecs(model.getDbQueryTimeInSecs());
            }
            if (model.wasPropertyExplicitlySet("totalWaits")) {
                this.totalWaits(model.getTotalWaits());
            }
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            return this;
        }
    }
}

