/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AwrDbParameterSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="instanceNumber")
    private final Integer instanceNumber;
    @JsonProperty(value="beginValue")
    private final String beginValue;
    @JsonProperty(value="endValue")
    private final String endValue;
    @JsonProperty(value="isChanged")
    private final Boolean isChanged;
    @JsonProperty(value="valueModified")
    private final String valueModified;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;

    @Deprecated
    @ConstructorProperties(value={"name", "instanceNumber", "beginValue", "endValue", "isChanged", "valueModified", "isDefault"})
    public AwrDbParameterSummary(String name, Integer instanceNumber, String beginValue, String endValue, Boolean isChanged, String valueModified, Boolean isDefault) {
        this.name = name;
        this.instanceNumber = instanceNumber;
        this.beginValue = beginValue;
        this.endValue = endValue;
        this.isChanged = isChanged;
        this.valueModified = valueModified;
        this.isDefault = isDefault;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getBeginValue() {
        return this.beginValue;
    }

    public String getEndValue() {
        return this.endValue;
    }

    public Boolean getIsChanged() {
        return this.isChanged;
    }

    public String getValueModified() {
        return this.valueModified;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AwrDbParameterSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", instanceNumber=").append(String.valueOf(this.instanceNumber));
        sb.append(", beginValue=").append(String.valueOf(this.beginValue));
        sb.append(", endValue=").append(String.valueOf(this.endValue));
        sb.append(", isChanged=").append(String.valueOf(this.isChanged));
        sb.append(", valueModified=").append(String.valueOf(this.valueModified));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwrDbParameterSummary)) {
            return false;
        }
        AwrDbParameterSummary other = (AwrDbParameterSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.instanceNumber, other.instanceNumber) && Objects.equals(this.beginValue, other.beginValue) && Objects.equals(this.endValue, other.endValue) && Objects.equals(this.isChanged, other.isChanged) && Objects.equals(this.valueModified, other.valueModified) && Objects.equals(this.isDefault, other.isDefault) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.instanceNumber == null ? 43 : this.instanceNumber.hashCode());
        result = result * 59 + (this.beginValue == null ? 43 : this.beginValue.hashCode());
        result = result * 59 + (this.endValue == null ? 43 : this.endValue.hashCode());
        result = result * 59 + (this.isChanged == null ? 43 : this.isChanged.hashCode());
        result = result * 59 + (this.valueModified == null ? 43 : this.valueModified.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="instanceNumber")
        private Integer instanceNumber;
        @JsonProperty(value="beginValue")
        private String beginValue;
        @JsonProperty(value="endValue")
        private String endValue;
        @JsonProperty(value="isChanged")
        private Boolean isChanged;
        @JsonProperty(value="valueModified")
        private String valueModified;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder instanceNumber(Integer instanceNumber) {
            this.instanceNumber = instanceNumber;
            this.__explicitlySet__.add("instanceNumber");
            return this;
        }

        public Builder beginValue(String beginValue) {
            this.beginValue = beginValue;
            this.__explicitlySet__.add("beginValue");
            return this;
        }

        public Builder endValue(String endValue) {
            this.endValue = endValue;
            this.__explicitlySet__.add("endValue");
            return this;
        }

        public Builder isChanged(Boolean isChanged) {
            this.isChanged = isChanged;
            this.__explicitlySet__.add("isChanged");
            return this;
        }

        public Builder valueModified(String valueModified) {
            this.valueModified = valueModified;
            this.__explicitlySet__.add("valueModified");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public AwrDbParameterSummary build() {
            AwrDbParameterSummary model = new AwrDbParameterSummary(this.name, this.instanceNumber, this.beginValue, this.endValue, this.isChanged, this.valueModified, this.isDefault);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AwrDbParameterSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("instanceNumber")) {
                this.instanceNumber(model.getInstanceNumber());
            }
            if (model.wasPropertyExplicitlySet("beginValue")) {
                this.beginValue(model.getBeginValue());
            }
            if (model.wasPropertyExplicitlySet("endValue")) {
                this.endValue(model.getEndValue());
            }
            if (model.wasPropertyExplicitlySet("isChanged")) {
                this.isChanged(model.getIsChanged());
            }
            if (model.wasPropertyExplicitlySet("valueModified")) {
                this.valueModified(model.getValueModified());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            return this;
        }
    }
}

