/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AwrDbMetricSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="avgValue")
    private final Double avgValue;
    @JsonProperty(value="minValue")
    private final Double minValue;
    @JsonProperty(value="maxValue")
    private final Double maxValue;

    @Deprecated
    @ConstructorProperties(value={"name", "timestamp", "avgValue", "minValue", "maxValue"})
    public AwrDbMetricSummary(String name, Date timestamp, Double avgValue, Double minValue, Double maxValue) {
        this.name = name;
        this.timestamp = timestamp;
        this.avgValue = avgValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Double getAvgValue() {
        return this.avgValue;
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AwrDbMetricSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", avgValue=").append(String.valueOf(this.avgValue));
        sb.append(", minValue=").append(String.valueOf(this.minValue));
        sb.append(", maxValue=").append(String.valueOf(this.maxValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwrDbMetricSummary)) {
            return false;
        }
        AwrDbMetricSummary other = (AwrDbMetricSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.avgValue, other.avgValue) && Objects.equals(this.minValue, other.minValue) && Objects.equals(this.maxValue, other.maxValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.avgValue == null ? 43 : this.avgValue.hashCode());
        result = result * 59 + (this.minValue == null ? 43 : this.minValue.hashCode());
        result = result * 59 + (this.maxValue == null ? 43 : this.maxValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="avgValue")
        private Double avgValue;
        @JsonProperty(value="minValue")
        private Double minValue;
        @JsonProperty(value="maxValue")
        private Double maxValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder avgValue(Double avgValue) {
            this.avgValue = avgValue;
            this.__explicitlySet__.add("avgValue");
            return this;
        }

        public Builder minValue(Double minValue) {
            this.minValue = minValue;
            this.__explicitlySet__.add("minValue");
            return this;
        }

        public Builder maxValue(Double maxValue) {
            this.maxValue = maxValue;
            this.__explicitlySet__.add("maxValue");
            return this;
        }

        public AwrDbMetricSummary build() {
            AwrDbMetricSummary model = new AwrDbMetricSummary(this.name, this.timestamp, this.avgValue, this.minValue, this.maxValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AwrDbMetricSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("avgValue")) {
                this.avgValue(model.getAvgValue());
            }
            if (model.wasPropertyExplicitlySet("minValue")) {
                this.minValue(model.getMinValue());
            }
            if (model.wasPropertyExplicitlySet("maxValue")) {
                this.maxValue(model.getMaxValue());
            }
            return this;
        }
    }
}

