/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.InfoForNetworkGenDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GenerateRecommendedNetworkDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="dbServers")
    private final List<String> dbServers;
    @JsonProperty(value="scanListenerPortTcp")
    private final Integer scanListenerPortTcp;
    @JsonProperty(value="scanListenerPortTcpSsl")
    private final Integer scanListenerPortTcpSsl;
    @JsonProperty(value="networks")
    private final List<InfoForNetworkGenDetails> networks;
    @JsonProperty(value="dns")
    private final List<String> dns;
    @JsonProperty(value="ntp")
    private final List<String> ntp;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "displayName", "dbServers", "scanListenerPortTcp", "scanListenerPortTcpSsl", "networks", "dns", "ntp", "freeformTags", "definedTags"})
    public GenerateRecommendedNetworkDetails(String compartmentId, String displayName, List<String> dbServers, Integer scanListenerPortTcp, Integer scanListenerPortTcpSsl, List<InfoForNetworkGenDetails> networks, List<String> dns, List<String> ntp, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.dbServers = dbServers;
        this.scanListenerPortTcp = scanListenerPortTcp;
        this.scanListenerPortTcpSsl = scanListenerPortTcpSsl;
        this.networks = networks;
        this.dns = dns;
        this.ntp = ntp;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getDbServers() {
        return this.dbServers;
    }

    public Integer getScanListenerPortTcp() {
        return this.scanListenerPortTcp;
    }

    public Integer getScanListenerPortTcpSsl() {
        return this.scanListenerPortTcpSsl;
    }

    public List<InfoForNetworkGenDetails> getNetworks() {
        return this.networks;
    }

    public List<String> getDns() {
        return this.dns;
    }

    public List<String> getNtp() {
        return this.ntp;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GenerateRecommendedNetworkDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", dbServers=").append(String.valueOf(this.dbServers));
        sb.append(", scanListenerPortTcp=").append(String.valueOf(this.scanListenerPortTcp));
        sb.append(", scanListenerPortTcpSsl=").append(String.valueOf(this.scanListenerPortTcpSsl));
        sb.append(", networks=").append(String.valueOf(this.networks));
        sb.append(", dns=").append(String.valueOf(this.dns));
        sb.append(", ntp=").append(String.valueOf(this.ntp));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateRecommendedNetworkDetails)) {
            return false;
        }
        GenerateRecommendedNetworkDetails other = (GenerateRecommendedNetworkDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.dbServers, other.dbServers) && Objects.equals(this.scanListenerPortTcp, other.scanListenerPortTcp) && Objects.equals(this.scanListenerPortTcpSsl, other.scanListenerPortTcpSsl) && Objects.equals(this.networks, other.networks) && Objects.equals(this.dns, other.dns) && Objects.equals(this.ntp, other.ntp) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.dbServers == null ? 43 : this.dbServers.hashCode());
        result = result * 59 + (this.scanListenerPortTcp == null ? 43 : this.scanListenerPortTcp.hashCode());
        result = result * 59 + (this.scanListenerPortTcpSsl == null ? 43 : this.scanListenerPortTcpSsl.hashCode());
        result = result * 59 + (this.networks == null ? 43 : this.networks.hashCode());
        result = result * 59 + (this.dns == null ? 43 : this.dns.hashCode());
        result = result * 59 + (this.ntp == null ? 43 : this.ntp.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="dbServers")
        private List<String> dbServers;
        @JsonProperty(value="scanListenerPortTcp")
        private Integer scanListenerPortTcp;
        @JsonProperty(value="scanListenerPortTcpSsl")
        private Integer scanListenerPortTcpSsl;
        @JsonProperty(value="networks")
        private List<InfoForNetworkGenDetails> networks;
        @JsonProperty(value="dns")
        private List<String> dns;
        @JsonProperty(value="ntp")
        private List<String> ntp;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder dbServers(List<String> dbServers) {
            this.dbServers = dbServers;
            this.__explicitlySet__.add("dbServers");
            return this;
        }

        public Builder scanListenerPortTcp(Integer scanListenerPortTcp) {
            this.scanListenerPortTcp = scanListenerPortTcp;
            this.__explicitlySet__.add("scanListenerPortTcp");
            return this;
        }

        public Builder scanListenerPortTcpSsl(Integer scanListenerPortTcpSsl) {
            this.scanListenerPortTcpSsl = scanListenerPortTcpSsl;
            this.__explicitlySet__.add("scanListenerPortTcpSsl");
            return this;
        }

        public Builder networks(List<InfoForNetworkGenDetails> networks) {
            this.networks = networks;
            this.__explicitlySet__.add("networks");
            return this;
        }

        public Builder dns(List<String> dns) {
            this.dns = dns;
            this.__explicitlySet__.add("dns");
            return this;
        }

        public Builder ntp(List<String> ntp) {
            this.ntp = ntp;
            this.__explicitlySet__.add("ntp");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public GenerateRecommendedNetworkDetails build() {
            GenerateRecommendedNetworkDetails model = new GenerateRecommendedNetworkDetails(this.compartmentId, this.displayName, this.dbServers, this.scanListenerPortTcp, this.scanListenerPortTcpSsl, this.networks, this.dns, this.ntp, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GenerateRecommendedNetworkDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("dbServers")) {
                this.dbServers(model.getDbServers());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortTcp")) {
                this.scanListenerPortTcp(model.getScanListenerPortTcp());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortTcpSsl")) {
                this.scanListenerPortTcpSsl(model.getScanListenerPortTcpSsl());
            }
            if (model.wasPropertyExplicitlySet("networks")) {
                this.networks(model.getNetworks());
            }
            if (model.wasPropertyExplicitlySet("dns")) {
                this.dns(model.getDns());
            }
            if (model.wasPropertyExplicitlySet("ntp")) {
                this.ntp(model.getNtp());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

