/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbNodeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="dbSystemId")
    private final String dbSystemId;
    @JsonProperty(value="vnicId")
    private final String vnicId;
    @JsonProperty(value="backupVnicId")
    private final String backupVnicId;
    @JsonProperty(value="hostIpId")
    private final String hostIpId;
    @JsonProperty(value="backupIpId")
    private final String backupIpId;
    @JsonProperty(value="vnic2Id")
    private final String vnic2Id;
    @JsonProperty(value="backupVnic2Id")
    private final String backupVnic2Id;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="softwareStorageSizeInGB")
    private final Integer softwareStorageSizeInGB;
    @JsonProperty(value="maintenanceType")
    private final MaintenanceType maintenanceType;
    @JsonProperty(value="timeMaintenanceWindowStart")
    private final Date timeMaintenanceWindowStart;
    @JsonProperty(value="timeMaintenanceWindowEnd")
    private final Date timeMaintenanceWindowEnd;
    @JsonProperty(value="additionalDetails")
    private final String additionalDetails;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;
    @JsonProperty(value="dbNodeStorageSizeInGBs")
    private final Integer dbNodeStorageSizeInGBs;
    @JsonProperty(value="dbServerId")
    private final String dbServerId;

    @Deprecated
    @ConstructorProperties(value={"id", "dbSystemId", "vnicId", "backupVnicId", "hostIpId", "backupIpId", "vnic2Id", "backupVnic2Id", "lifecycleState", "hostname", "faultDomain", "timeCreated", "softwareStorageSizeInGB", "maintenanceType", "timeMaintenanceWindowStart", "timeMaintenanceWindowEnd", "additionalDetails", "cpuCoreCount", "memorySizeInGBs", "dbNodeStorageSizeInGBs", "dbServerId"})
    public DbNodeSummary(String id, String dbSystemId, String vnicId, String backupVnicId, String hostIpId, String backupIpId, String vnic2Id, String backupVnic2Id, LifecycleState lifecycleState, String hostname, String faultDomain, Date timeCreated, Integer softwareStorageSizeInGB, MaintenanceType maintenanceType, Date timeMaintenanceWindowStart, Date timeMaintenanceWindowEnd, String additionalDetails, Integer cpuCoreCount, Integer memorySizeInGBs, Integer dbNodeStorageSizeInGBs, String dbServerId) {
        this.id = id;
        this.dbSystemId = dbSystemId;
        this.vnicId = vnicId;
        this.backupVnicId = backupVnicId;
        this.hostIpId = hostIpId;
        this.backupIpId = backupIpId;
        this.vnic2Id = vnic2Id;
        this.backupVnic2Id = backupVnic2Id;
        this.lifecycleState = lifecycleState;
        this.hostname = hostname;
        this.faultDomain = faultDomain;
        this.timeCreated = timeCreated;
        this.softwareStorageSizeInGB = softwareStorageSizeInGB;
        this.maintenanceType = maintenanceType;
        this.timeMaintenanceWindowStart = timeMaintenanceWindowStart;
        this.timeMaintenanceWindowEnd = timeMaintenanceWindowEnd;
        this.additionalDetails = additionalDetails;
        this.cpuCoreCount = cpuCoreCount;
        this.memorySizeInGBs = memorySizeInGBs;
        this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        this.dbServerId = dbServerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getVnicId() {
        return this.vnicId;
    }

    public String getBackupVnicId() {
        return this.backupVnicId;
    }

    public String getHostIpId() {
        return this.hostIpId;
    }

    public String getBackupIpId() {
        return this.backupIpId;
    }

    public String getVnic2Id() {
        return this.vnic2Id;
    }

    public String getBackupVnic2Id() {
        return this.backupVnic2Id;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Integer getSoftwareStorageSizeInGB() {
        return this.softwareStorageSizeInGB;
    }

    public MaintenanceType getMaintenanceType() {
        return this.maintenanceType;
    }

    public Date getTimeMaintenanceWindowStart() {
        return this.timeMaintenanceWindowStart;
    }

    public Date getTimeMaintenanceWindowEnd() {
        return this.timeMaintenanceWindowEnd;
    }

    public String getAdditionalDetails() {
        return this.additionalDetails;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public Integer getDbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public String getDbServerId() {
        return this.dbServerId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbNodeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(", vnicId=").append(String.valueOf(this.vnicId));
        sb.append(", backupVnicId=").append(String.valueOf(this.backupVnicId));
        sb.append(", hostIpId=").append(String.valueOf(this.hostIpId));
        sb.append(", backupIpId=").append(String.valueOf(this.backupIpId));
        sb.append(", vnic2Id=").append(String.valueOf(this.vnic2Id));
        sb.append(", backupVnic2Id=").append(String.valueOf(this.backupVnic2Id));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", hostname=").append(String.valueOf(this.hostname));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", softwareStorageSizeInGB=").append(String.valueOf(this.softwareStorageSizeInGB));
        sb.append(", maintenanceType=").append(String.valueOf((Object)this.maintenanceType));
        sb.append(", timeMaintenanceWindowStart=").append(String.valueOf(this.timeMaintenanceWindowStart));
        sb.append(", timeMaintenanceWindowEnd=").append(String.valueOf(this.timeMaintenanceWindowEnd));
        sb.append(", additionalDetails=").append(String.valueOf(this.additionalDetails));
        sb.append(", cpuCoreCount=").append(String.valueOf(this.cpuCoreCount));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(", dbNodeStorageSizeInGBs=").append(String.valueOf(this.dbNodeStorageSizeInGBs));
        sb.append(", dbServerId=").append(String.valueOf(this.dbServerId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbNodeSummary)) {
            return false;
        }
        DbNodeSummary other = (DbNodeSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.vnicId, other.vnicId) && Objects.equals(this.backupVnicId, other.backupVnicId) && Objects.equals(this.hostIpId, other.hostIpId) && Objects.equals(this.backupIpId, other.backupIpId) && Objects.equals(this.vnic2Id, other.vnic2Id) && Objects.equals(this.backupVnic2Id, other.backupVnic2Id) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.softwareStorageSizeInGB, other.softwareStorageSizeInGB) && Objects.equals((Object)this.maintenanceType, (Object)other.maintenanceType) && Objects.equals(this.timeMaintenanceWindowStart, other.timeMaintenanceWindowStart) && Objects.equals(this.timeMaintenanceWindowEnd, other.timeMaintenanceWindowEnd) && Objects.equals(this.additionalDetails, other.additionalDetails) && Objects.equals(this.cpuCoreCount, other.cpuCoreCount) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && Objects.equals(this.dbNodeStorageSizeInGBs, other.dbNodeStorageSizeInGBs) && Objects.equals(this.dbServerId, other.dbServerId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.vnicId == null ? 43 : this.vnicId.hashCode());
        result = result * 59 + (this.backupVnicId == null ? 43 : this.backupVnicId.hashCode());
        result = result * 59 + (this.hostIpId == null ? 43 : this.hostIpId.hashCode());
        result = result * 59 + (this.backupIpId == null ? 43 : this.backupIpId.hashCode());
        result = result * 59 + (this.vnic2Id == null ? 43 : this.vnic2Id.hashCode());
        result = result * 59 + (this.backupVnic2Id == null ? 43 : this.backupVnic2Id.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.softwareStorageSizeInGB == null ? 43 : this.softwareStorageSizeInGB.hashCode());
        result = result * 59 + (this.maintenanceType == null ? 43 : this.maintenanceType.hashCode());
        result = result * 59 + (this.timeMaintenanceWindowStart == null ? 43 : this.timeMaintenanceWindowStart.hashCode());
        result = result * 59 + (this.timeMaintenanceWindowEnd == null ? 43 : this.timeMaintenanceWindowEnd.hashCode());
        result = result * 59 + (this.additionalDetails == null ? 43 : this.additionalDetails.hashCode());
        result = result * 59 + (this.cpuCoreCount == null ? 43 : this.cpuCoreCount.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + (this.dbNodeStorageSizeInGBs == null ? 43 : this.dbNodeStorageSizeInGBs.hashCode());
        result = result * 59 + (this.dbServerId == null ? 43 : this.dbServerId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MaintenanceType implements BmcEnum
    {
        VmdbRebootMigration("VMDB_REBOOT_MIGRATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MaintenanceType> map;

        private MaintenanceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MaintenanceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MaintenanceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MaintenanceType.class);
            map = new HashMap<String, MaintenanceType>();
            for (MaintenanceType v : MaintenanceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Stopping("STOPPING"),
        Stopped("STOPPED"),
        Starting("STARTING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="dbSystemId")
        private String dbSystemId;
        @JsonProperty(value="vnicId")
        private String vnicId;
        @JsonProperty(value="backupVnicId")
        private String backupVnicId;
        @JsonProperty(value="hostIpId")
        private String hostIpId;
        @JsonProperty(value="backupIpId")
        private String backupIpId;
        @JsonProperty(value="vnic2Id")
        private String vnic2Id;
        @JsonProperty(value="backupVnic2Id")
        private String backupVnic2Id;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="softwareStorageSizeInGB")
        private Integer softwareStorageSizeInGB;
        @JsonProperty(value="maintenanceType")
        private MaintenanceType maintenanceType;
        @JsonProperty(value="timeMaintenanceWindowStart")
        private Date timeMaintenanceWindowStart;
        @JsonProperty(value="timeMaintenanceWindowEnd")
        private Date timeMaintenanceWindowEnd;
        @JsonProperty(value="additionalDetails")
        private String additionalDetails;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonProperty(value="dbNodeStorageSizeInGBs")
        private Integer dbNodeStorageSizeInGBs;
        @JsonProperty(value="dbServerId")
        private String dbServerId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            this.__explicitlySet__.add("dbSystemId");
            return this;
        }

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            this.__explicitlySet__.add("vnicId");
            return this;
        }

        public Builder backupVnicId(String backupVnicId) {
            this.backupVnicId = backupVnicId;
            this.__explicitlySet__.add("backupVnicId");
            return this;
        }

        public Builder hostIpId(String hostIpId) {
            this.hostIpId = hostIpId;
            this.__explicitlySet__.add("hostIpId");
            return this;
        }

        public Builder backupIpId(String backupIpId) {
            this.backupIpId = backupIpId;
            this.__explicitlySet__.add("backupIpId");
            return this;
        }

        public Builder vnic2Id(String vnic2Id) {
            this.vnic2Id = vnic2Id;
            this.__explicitlySet__.add("vnic2Id");
            return this;
        }

        public Builder backupVnic2Id(String backupVnic2Id) {
            this.backupVnic2Id = backupVnic2Id;
            this.__explicitlySet__.add("backupVnic2Id");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder softwareStorageSizeInGB(Integer softwareStorageSizeInGB) {
            this.softwareStorageSizeInGB = softwareStorageSizeInGB;
            this.__explicitlySet__.add("softwareStorageSizeInGB");
            return this;
        }

        public Builder maintenanceType(MaintenanceType maintenanceType) {
            this.maintenanceType = maintenanceType;
            this.__explicitlySet__.add("maintenanceType");
            return this;
        }

        public Builder timeMaintenanceWindowStart(Date timeMaintenanceWindowStart) {
            this.timeMaintenanceWindowStart = timeMaintenanceWindowStart;
            this.__explicitlySet__.add("timeMaintenanceWindowStart");
            return this;
        }

        public Builder timeMaintenanceWindowEnd(Date timeMaintenanceWindowEnd) {
            this.timeMaintenanceWindowEnd = timeMaintenanceWindowEnd;
            this.__explicitlySet__.add("timeMaintenanceWindowEnd");
            return this;
        }

        public Builder additionalDetails(String additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.__explicitlySet__.add("additionalDetails");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            this.__explicitlySet__.add("dbNodeStorageSizeInGBs");
            return this;
        }

        public Builder dbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
            this.__explicitlySet__.add("dbServerId");
            return this;
        }

        public DbNodeSummary build() {
            DbNodeSummary model = new DbNodeSummary(this.id, this.dbSystemId, this.vnicId, this.backupVnicId, this.hostIpId, this.backupIpId, this.vnic2Id, this.backupVnic2Id, this.lifecycleState, this.hostname, this.faultDomain, this.timeCreated, this.softwareStorageSizeInGB, this.maintenanceType, this.timeMaintenanceWindowStart, this.timeMaintenanceWindowEnd, this.additionalDetails, this.cpuCoreCount, this.memorySizeInGBs, this.dbNodeStorageSizeInGBs, this.dbServerId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbNodeSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("dbSystemId")) {
                this.dbSystemId(model.getDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("vnicId")) {
                this.vnicId(model.getVnicId());
            }
            if (model.wasPropertyExplicitlySet("backupVnicId")) {
                this.backupVnicId(model.getBackupVnicId());
            }
            if (model.wasPropertyExplicitlySet("hostIpId")) {
                this.hostIpId(model.getHostIpId());
            }
            if (model.wasPropertyExplicitlySet("backupIpId")) {
                this.backupIpId(model.getBackupIpId());
            }
            if (model.wasPropertyExplicitlySet("vnic2Id")) {
                this.vnic2Id(model.getVnic2Id());
            }
            if (model.wasPropertyExplicitlySet("backupVnic2Id")) {
                this.backupVnic2Id(model.getBackupVnic2Id());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("softwareStorageSizeInGB")) {
                this.softwareStorageSizeInGB(model.getSoftwareStorageSizeInGB());
            }
            if (model.wasPropertyExplicitlySet("maintenanceType")) {
                this.maintenanceType(model.getMaintenanceType());
            }
            if (model.wasPropertyExplicitlySet("timeMaintenanceWindowStart")) {
                this.timeMaintenanceWindowStart(model.getTimeMaintenanceWindowStart());
            }
            if (model.wasPropertyExplicitlySet("timeMaintenanceWindowEnd")) {
                this.timeMaintenanceWindowEnd(model.getTimeMaintenanceWindowEnd());
            }
            if (model.wasPropertyExplicitlySet("additionalDetails")) {
                this.additionalDetails(model.getAdditionalDetails());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCount")) {
                this.cpuCoreCount(model.getCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("dbNodeStorageSizeInGBs")) {
                this.dbNodeStorageSizeInGBs(model.getDbNodeStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("dbServerId")) {
                this.dbServerId(model.getDbServerId());
            }
            return this;
        }
    }
}

