/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dashboardservice.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dashboardservice.model.UpdateDashboardDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDashboardRequest
extends BmcRequest<UpdateDashboardDetails> {
    private String dashboardId;
    private UpdateDashboardDetails updateDashboardDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcCrossRegion;

    public String getDashboardId() {
        return this.dashboardId;
    }

    public UpdateDashboardDetails getUpdateDashboardDetails() {
        return this.updateDashboardDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcCrossRegion() {
        return this.opcCrossRegion;
    }

    @InternalSdk
    public UpdateDashboardDetails getBody$() {
        return this.updateDashboardDetails;
    }

    public Builder toBuilder() {
        return new Builder().dashboardId(this.dashboardId).updateDashboardDetails(this.updateDashboardDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcCrossRegion(this.opcCrossRegion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dashboardId=").append(String.valueOf(this.dashboardId));
        sb.append(",updateDashboardDetails=").append(String.valueOf((Object)this.updateDashboardDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcCrossRegion=").append(String.valueOf(this.opcCrossRegion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDashboardRequest)) {
            return false;
        }
        UpdateDashboardRequest other = (UpdateDashboardRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dashboardId, other.dashboardId) && Objects.equals((Object)this.updateDashboardDetails, (Object)other.updateDashboardDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcCrossRegion, other.opcCrossRegion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dashboardId == null ? 43 : this.dashboardId.hashCode());
        result = result * 59 + (this.updateDashboardDetails == null ? 43 : this.updateDashboardDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcCrossRegion == null ? 43 : this.opcCrossRegion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDashboardRequest, UpdateDashboardDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dashboardId = null;
        private UpdateDashboardDetails updateDashboardDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcCrossRegion = null;

        public Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public Builder updateDashboardDetails(UpdateDashboardDetails updateDashboardDetails) {
            this.updateDashboardDetails = updateDashboardDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcCrossRegion(String opcCrossRegion) {
            this.opcCrossRegion = opcCrossRegion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDashboardRequest o) {
            this.dashboardId(o.getDashboardId());
            this.updateDashboardDetails(o.getUpdateDashboardDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcCrossRegion(o.getOpcCrossRegion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDashboardRequest build() {
            UpdateDashboardRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDashboardDetails body) {
            this.updateDashboardDetails(body);
            return this;
        }

        public UpdateDashboardRequest buildWithoutInvocationCallback() {
            UpdateDashboardRequest request = new UpdateDashboardRequest();
            request.dashboardId = this.dashboardId;
            request.updateDashboardDetails = this.updateDashboardDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcCrossRegion = this.opcCrossRegion;
            return request;
        }
    }
}

