/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dashboardservice;

import com.oracle.bmc.dashboardservice.DashboardGroup;
import com.oracle.bmc.dashboardservice.model.DashboardGroupSummary;
import com.oracle.bmc.dashboardservice.requests.ListDashboardGroupsRequest;
import com.oracle.bmc.dashboardservice.responses.ListDashboardGroupsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DashboardGroupPaginators {
    private final DashboardGroup client;

    public DashboardGroupPaginators(DashboardGroup client) {
        this.client = client;
    }

    public Iterable<ListDashboardGroupsResponse> listDashboardGroupsResponseIterator(final ListDashboardGroupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDashboardGroupsRequest.Builder>(){

            @Override
            public ListDashboardGroupsRequest.Builder get() {
                return ListDashboardGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDashboardGroupsResponse, String>(){

            @Override
            public String apply(ListDashboardGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDashboardGroupsRequest.Builder>, ListDashboardGroupsRequest>(){

            @Override
            public ListDashboardGroupsRequest apply(RequestBuilderAndToken<ListDashboardGroupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDashboardGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDashboardGroupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDashboardGroupsRequest, ListDashboardGroupsResponse>(){

            @Override
            public ListDashboardGroupsResponse apply(ListDashboardGroupsRequest request) {
                return DashboardGroupPaginators.this.client.listDashboardGroups(request);
            }
        });
    }

    public Iterable<DashboardGroupSummary> listDashboardGroupsRecordIterator(final ListDashboardGroupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDashboardGroupsRequest.Builder>(){

            @Override
            public ListDashboardGroupsRequest.Builder get() {
                return ListDashboardGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDashboardGroupsResponse, String>(){

            @Override
            public String apply(ListDashboardGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDashboardGroupsRequest.Builder>, ListDashboardGroupsRequest>(){

            @Override
            public ListDashboardGroupsRequest apply(RequestBuilderAndToken<ListDashboardGroupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDashboardGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDashboardGroupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDashboardGroupsRequest, ListDashboardGroupsResponse>(){

            @Override
            public ListDashboardGroupsResponse apply(ListDashboardGroupsRequest request) {
                return DashboardGroupPaginators.this.client.listDashboardGroups(request);
            }
        }, (Function)new Function<ListDashboardGroupsResponse, List<DashboardGroupSummary>>(){

            @Override
            public List<DashboardGroupSummary> apply(ListDashboardGroupsResponse response) {
                return response.getDashboardGroupCollection().getItems();
            }
        });
    }
}

