/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.responses;

import com.oracle.bmc.containerinstances.model.Container;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetContainerResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private Container container;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Container getContainer() {
        return this.container;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "container"})
    private GetContainerResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, Container container) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.container = container;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",container=").append(String.valueOf((Object)this.container));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetContainerResponse)) {
            return false;
        }
        GetContainerResponse other = (GetContainerResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.container, (Object)other.container);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.container == null ? 43 : this.container.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetContainerResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private Container container;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder container(Container container) {
            this.container = container;
            return this;
        }

        public Builder copy(GetContainerResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.container(o.getContainer());
            return this;
        }

        public GetContainerResponse build() {
            return new GetContainerResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.container);
        }
    }
}

