/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.containerinstances.model.UpdateContainerDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateContainerRequest
extends BmcRequest<UpdateContainerDetails> {
    private String containerId;
    private UpdateContainerDetails updateContainerDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getContainerId() {
        return this.containerId;
    }

    public UpdateContainerDetails getUpdateContainerDetails() {
        return this.updateContainerDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateContainerDetails getBody$() {
        return this.updateContainerDetails;
    }

    public Builder toBuilder() {
        return new Builder().containerId(this.containerId).updateContainerDetails(this.updateContainerDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",containerId=").append(String.valueOf(this.containerId));
        sb.append(",updateContainerDetails=").append(String.valueOf((Object)this.updateContainerDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateContainerRequest)) {
            return false;
        }
        UpdateContainerRequest other = (UpdateContainerRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.containerId, other.containerId) && Objects.equals((Object)this.updateContainerDetails, (Object)other.updateContainerDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.containerId == null ? 43 : this.containerId.hashCode());
        result = result * 59 + (this.updateContainerDetails == null ? 43 : this.updateContainerDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateContainerRequest, UpdateContainerDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String containerId = null;
        private UpdateContainerDetails updateContainerDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder containerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        public Builder updateContainerDetails(UpdateContainerDetails updateContainerDetails) {
            this.updateContainerDetails = updateContainerDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateContainerRequest o) {
            this.containerId(o.getContainerId());
            this.updateContainerDetails(o.getUpdateContainerDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateContainerRequest build() {
            UpdateContainerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateContainerDetails body) {
            this.updateContainerDetails(body);
            return this;
        }

        public UpdateContainerRequest buildWithoutInvocationCallback() {
            UpdateContainerRequest request = new UpdateContainerRequest();
            request.containerId = this.containerId;
            request.updateContainerDetails = this.updateContainerDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

