/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.containerinstances.model.CreateContainerInstanceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateContainerInstanceRequest
extends BmcRequest<CreateContainerInstanceDetails> {
    private CreateContainerInstanceDetails createContainerInstanceDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreateContainerInstanceDetails getCreateContainerInstanceDetails() {
        return this.createContainerInstanceDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateContainerInstanceDetails getBody$() {
        return this.createContainerInstanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().createContainerInstanceDetails(this.createContainerInstanceDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createContainerInstanceDetails=").append(String.valueOf((Object)this.createContainerInstanceDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateContainerInstanceRequest)) {
            return false;
        }
        CreateContainerInstanceRequest other = (CreateContainerInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createContainerInstanceDetails, (Object)other.createContainerInstanceDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createContainerInstanceDetails == null ? 43 : this.createContainerInstanceDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateContainerInstanceRequest, CreateContainerInstanceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateContainerInstanceDetails createContainerInstanceDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createContainerInstanceDetails(CreateContainerInstanceDetails createContainerInstanceDetails) {
            this.createContainerInstanceDetails = createContainerInstanceDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateContainerInstanceRequest o) {
            this.createContainerInstanceDetails(o.getCreateContainerInstanceDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateContainerInstanceRequest build() {
            CreateContainerInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateContainerInstanceDetails body) {
            this.createContainerInstanceDetails(body);
            return this;
        }

        public CreateContainerInstanceRequest buildWithoutInvocationCallback() {
            CreateContainerInstanceRequest request = new CreateContainerInstanceRequest();
            request.createContainerInstanceDetails = this.createContainerInstanceDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

