/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ContainerInstanceShapeConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ocpus")
    private final Float ocpus;
    @JsonProperty(value="memoryInGBs")
    private final Float memoryInGBs;
    @JsonProperty(value="processorDescription")
    private final String processorDescription;
    @JsonProperty(value="networkingBandwidthInGbps")
    private final Float networkingBandwidthInGbps;

    @Deprecated
    @ConstructorProperties(value={"ocpus", "memoryInGBs", "processorDescription", "networkingBandwidthInGbps"})
    public ContainerInstanceShapeConfig(Float ocpus, Float memoryInGBs, String processorDescription, Float networkingBandwidthInGbps) {
        this.ocpus = ocpus;
        this.memoryInGBs = memoryInGBs;
        this.processorDescription = processorDescription;
        this.networkingBandwidthInGbps = networkingBandwidthInGbps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getOcpus() {
        return this.ocpus;
    }

    public Float getMemoryInGBs() {
        return this.memoryInGBs;
    }

    public String getProcessorDescription() {
        return this.processorDescription;
    }

    public Float getNetworkingBandwidthInGbps() {
        return this.networkingBandwidthInGbps;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerInstanceShapeConfig(");
        sb.append("super=").append(super.toString());
        sb.append("ocpus=").append(String.valueOf(this.ocpus));
        sb.append(", memoryInGBs=").append(String.valueOf(this.memoryInGBs));
        sb.append(", processorDescription=").append(String.valueOf(this.processorDescription));
        sb.append(", networkingBandwidthInGbps=").append(String.valueOf(this.networkingBandwidthInGbps));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerInstanceShapeConfig)) {
            return false;
        }
        ContainerInstanceShapeConfig other = (ContainerInstanceShapeConfig)((Object)o);
        return Objects.equals(this.ocpus, other.ocpus) && Objects.equals(this.memoryInGBs, other.memoryInGBs) && Objects.equals(this.processorDescription, other.processorDescription) && Objects.equals(this.networkingBandwidthInGbps, other.networkingBandwidthInGbps) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ocpus == null ? 43 : this.ocpus.hashCode());
        result = result * 59 + (this.memoryInGBs == null ? 43 : this.memoryInGBs.hashCode());
        result = result * 59 + (this.processorDescription == null ? 43 : this.processorDescription.hashCode());
        result = result * 59 + (this.networkingBandwidthInGbps == null ? 43 : this.networkingBandwidthInGbps.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ocpus")
        private Float ocpus;
        @JsonProperty(value="memoryInGBs")
        private Float memoryInGBs;
        @JsonProperty(value="processorDescription")
        private String processorDescription;
        @JsonProperty(value="networkingBandwidthInGbps")
        private Float networkingBandwidthInGbps;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ocpus(Float ocpus) {
            this.ocpus = ocpus;
            this.__explicitlySet__.add("ocpus");
            return this;
        }

        public Builder memoryInGBs(Float memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public Builder processorDescription(String processorDescription) {
            this.processorDescription = processorDescription;
            this.__explicitlySet__.add("processorDescription");
            return this;
        }

        public Builder networkingBandwidthInGbps(Float networkingBandwidthInGbps) {
            this.networkingBandwidthInGbps = networkingBandwidthInGbps;
            this.__explicitlySet__.add("networkingBandwidthInGbps");
            return this;
        }

        public ContainerInstanceShapeConfig build() {
            ContainerInstanceShapeConfig model = new ContainerInstanceShapeConfig(this.ocpus, this.memoryInGBs, this.processorDescription, this.networkingBandwidthInGbps);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerInstanceShapeConfig model) {
            if (model.wasPropertyExplicitlySet("ocpus")) {
                this.ocpus(model.getOcpus());
            }
            if (model.wasPropertyExplicitlySet("memoryInGBs")) {
                this.memoryInGBs(model.getMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("processorDescription")) {
                this.processorDescription(model.getProcessorDescription());
            }
            if (model.wasPropertyExplicitlySet("networkingBandwidthInGbps")) {
                this.networkingBandwidthInGbps(model.getNetworkingBandwidthInGbps());
            }
            return this;
        }
    }
}

