/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerinstances.model.ContainerVolume;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="volumeType")
@JsonFilter(value="explicitlySetFilter")
public final class ContainerEmptyDirVolume
extends ContainerVolume {
    @JsonProperty(value="backingStore")
    private final BackingStore backingStore;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ContainerEmptyDirVolume(String name, BackingStore backingStore) {
        super(name);
        this.backingStore = backingStore;
    }

    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerEmptyDirVolume(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", backingStore=").append(String.valueOf((Object)this.backingStore));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerEmptyDirVolume)) {
            return false;
        }
        ContainerEmptyDirVolume other = (ContainerEmptyDirVolume)((Object)o);
        return Objects.equals((Object)this.backingStore, (Object)other.backingStore) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.backingStore == null ? 43 : this.backingStore.hashCode());
        return result;
    }

    public static enum BackingStore implements BmcEnum
    {
        EphemeralStorage("EPHEMERAL_STORAGE"),
        Memory("MEMORY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BackingStore> map;

        private BackingStore(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BackingStore create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BackingStore', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BackingStore.class);
            map = new HashMap<String, BackingStore>();
            for (BackingStore v : BackingStore.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="backingStore")
        private BackingStore backingStore;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder backingStore(BackingStore backingStore) {
            this.backingStore = backingStore;
            this.__explicitlySet__.add("backingStore");
            return this;
        }

        public ContainerEmptyDirVolume build() {
            ContainerEmptyDirVolume model = new ContainerEmptyDirVolume(this.name, this.backingStore);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerEmptyDirVolume model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("backingStore")) {
                this.backingStore(model.getBackingStore());
            }
            return this;
        }
    }
}

