/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerinstances.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerinstances.model.ContainerCapability;
import com.oracle.bmc.containerinstances.model.ContainerHealthCheck;
import com.oracle.bmc.containerinstances.model.ContainerResourceConfig;
import com.oracle.bmc.containerinstances.model.VolumeMount;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Container
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="exitCode")
    private final Integer exitCode;
    @JsonProperty(value="timeTerminated")
    private final Date timeTerminated;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="containerInstanceId")
    private final String containerInstanceId;
    @JsonProperty(value="imageUrl")
    private final String imageUrl;
    @JsonProperty(value="command")
    private final List<String> command;
    @JsonProperty(value="arguments")
    private final List<String> arguments;
    @JsonProperty(value="additionalCapabilities")
    private final List<ContainerCapability> additionalCapabilities;
    @JsonProperty(value="workingDirectory")
    private final String workingDirectory;
    @JsonProperty(value="environmentVariables")
    private final Map<String, String> environmentVariables;
    @JsonProperty(value="volumeMounts")
    private final List<VolumeMount> volumeMounts;
    @JsonProperty(value="healthChecks")
    private final List<ContainerHealthCheck> healthChecks;
    @JsonProperty(value="isResourcePrincipalDisabled")
    private final Boolean isResourcePrincipalDisabled;
    @JsonProperty(value="resourceConfig")
    private final ContainerResourceConfig resourceConfig;
    @JsonProperty(value="containerRestartAttemptCount")
    private final Integer containerRestartAttemptCount;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "freeformTags", "definedTags", "systemTags", "availabilityDomain", "faultDomain", "lifecycleState", "lifecycleDetails", "exitCode", "timeTerminated", "timeCreated", "timeUpdated", "containerInstanceId", "imageUrl", "command", "arguments", "additionalCapabilities", "workingDirectory", "environmentVariables", "volumeMounts", "healthChecks", "isResourcePrincipalDisabled", "resourceConfig", "containerRestartAttemptCount"})
    public Container(String id, String displayName, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, String availabilityDomain, String faultDomain, LifecycleState lifecycleState, String lifecycleDetails, Integer exitCode, Date timeTerminated, Date timeCreated, Date timeUpdated, String containerInstanceId, String imageUrl, List<String> command, List<String> arguments, List<ContainerCapability> additionalCapabilities, String workingDirectory, Map<String, String> environmentVariables, List<VolumeMount> volumeMounts, List<ContainerHealthCheck> healthChecks, Boolean isResourcePrincipalDisabled, ContainerResourceConfig resourceConfig, Integer containerRestartAttemptCount) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.availabilityDomain = availabilityDomain;
        this.faultDomain = faultDomain;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.exitCode = exitCode;
        this.timeTerminated = timeTerminated;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.containerInstanceId = containerInstanceId;
        this.imageUrl = imageUrl;
        this.command = command;
        this.arguments = arguments;
        this.additionalCapabilities = additionalCapabilities;
        this.workingDirectory = workingDirectory;
        this.environmentVariables = environmentVariables;
        this.volumeMounts = volumeMounts;
        this.healthChecks = healthChecks;
        this.isResourcePrincipalDisabled = isResourcePrincipalDisabled;
        this.resourceConfig = resourceConfig;
        this.containerRestartAttemptCount = containerRestartAttemptCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public Date getTimeTerminated() {
        return this.timeTerminated;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getContainerInstanceId() {
        return this.containerInstanceId;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<ContainerCapability> getAdditionalCapabilities() {
        return this.additionalCapabilities;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public List<ContainerHealthCheck> getHealthChecks() {
        return this.healthChecks;
    }

    public Boolean getIsResourcePrincipalDisabled() {
        return this.isResourcePrincipalDisabled;
    }

    public ContainerResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public Integer getContainerRestartAttemptCount() {
        return this.containerRestartAttemptCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Container(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", exitCode=").append(String.valueOf(this.exitCode));
        sb.append(", timeTerminated=").append(String.valueOf(this.timeTerminated));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", containerInstanceId=").append(String.valueOf(this.containerInstanceId));
        sb.append(", imageUrl=").append(String.valueOf(this.imageUrl));
        sb.append(", command=").append(String.valueOf(this.command));
        sb.append(", arguments=").append(String.valueOf(this.arguments));
        sb.append(", additionalCapabilities=").append(String.valueOf(this.additionalCapabilities));
        sb.append(", workingDirectory=").append(String.valueOf(this.workingDirectory));
        sb.append(", environmentVariables=").append(String.valueOf(this.environmentVariables));
        sb.append(", volumeMounts=").append(String.valueOf(this.volumeMounts));
        sb.append(", healthChecks=").append(String.valueOf(this.healthChecks));
        sb.append(", isResourcePrincipalDisabled=").append(String.valueOf(this.isResourcePrincipalDisabled));
        sb.append(", resourceConfig=").append(String.valueOf((Object)this.resourceConfig));
        sb.append(", containerRestartAttemptCount=").append(String.valueOf(this.containerRestartAttemptCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container other = (Container)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.exitCode, other.exitCode) && Objects.equals(this.timeTerminated, other.timeTerminated) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.containerInstanceId, other.containerInstanceId) && Objects.equals(this.imageUrl, other.imageUrl) && Objects.equals(this.command, other.command) && Objects.equals(this.arguments, other.arguments) && Objects.equals(this.additionalCapabilities, other.additionalCapabilities) && Objects.equals(this.workingDirectory, other.workingDirectory) && Objects.equals(this.environmentVariables, other.environmentVariables) && Objects.equals(this.volumeMounts, other.volumeMounts) && Objects.equals(this.healthChecks, other.healthChecks) && Objects.equals(this.isResourcePrincipalDisabled, other.isResourcePrincipalDisabled) && Objects.equals((Object)this.resourceConfig, (Object)other.resourceConfig) && Objects.equals(this.containerRestartAttemptCount, other.containerRestartAttemptCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.exitCode == null ? 43 : this.exitCode.hashCode());
        result = result * 59 + (this.timeTerminated == null ? 43 : this.timeTerminated.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.containerInstanceId == null ? 43 : this.containerInstanceId.hashCode());
        result = result * 59 + (this.imageUrl == null ? 43 : this.imageUrl.hashCode());
        result = result * 59 + (this.command == null ? 43 : this.command.hashCode());
        result = result * 59 + (this.arguments == null ? 43 : this.arguments.hashCode());
        result = result * 59 + (this.additionalCapabilities == null ? 43 : this.additionalCapabilities.hashCode());
        result = result * 59 + (this.workingDirectory == null ? 43 : this.workingDirectory.hashCode());
        result = result * 59 + (this.environmentVariables == null ? 43 : this.environmentVariables.hashCode());
        result = result * 59 + (this.volumeMounts == null ? 43 : this.volumeMounts.hashCode());
        result = result * 59 + (this.healthChecks == null ? 43 : this.healthChecks.hashCode());
        result = result * 59 + (this.isResourcePrincipalDisabled == null ? 43 : this.isResourcePrincipalDisabled.hashCode());
        result = result * 59 + (this.resourceConfig == null ? 43 : this.resourceConfig.hashCode());
        result = result * 59 + (this.containerRestartAttemptCount == null ? 43 : this.containerRestartAttemptCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="exitCode")
        private Integer exitCode;
        @JsonProperty(value="timeTerminated")
        private Date timeTerminated;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="containerInstanceId")
        private String containerInstanceId;
        @JsonProperty(value="imageUrl")
        private String imageUrl;
        @JsonProperty(value="command")
        private List<String> command;
        @JsonProperty(value="arguments")
        private List<String> arguments;
        @JsonProperty(value="additionalCapabilities")
        private List<ContainerCapability> additionalCapabilities;
        @JsonProperty(value="workingDirectory")
        private String workingDirectory;
        @JsonProperty(value="environmentVariables")
        private Map<String, String> environmentVariables;
        @JsonProperty(value="volumeMounts")
        private List<VolumeMount> volumeMounts;
        @JsonProperty(value="healthChecks")
        private List<ContainerHealthCheck> healthChecks;
        @JsonProperty(value="isResourcePrincipalDisabled")
        private Boolean isResourcePrincipalDisabled;
        @JsonProperty(value="resourceConfig")
        private ContainerResourceConfig resourceConfig;
        @JsonProperty(value="containerRestartAttemptCount")
        private Integer containerRestartAttemptCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            this.__explicitlySet__.add("exitCode");
            return this;
        }

        public Builder timeTerminated(Date timeTerminated) {
            this.timeTerminated = timeTerminated;
            this.__explicitlySet__.add("timeTerminated");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder containerInstanceId(String containerInstanceId) {
            this.containerInstanceId = containerInstanceId;
            this.__explicitlySet__.add("containerInstanceId");
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            this.__explicitlySet__.add("imageUrl");
            return this;
        }

        public Builder command(List<String> command) {
            this.command = command;
            this.__explicitlySet__.add("command");
            return this;
        }

        public Builder arguments(List<String> arguments) {
            this.arguments = arguments;
            this.__explicitlySet__.add("arguments");
            return this;
        }

        public Builder additionalCapabilities(List<ContainerCapability> additionalCapabilities) {
            this.additionalCapabilities = additionalCapabilities;
            this.__explicitlySet__.add("additionalCapabilities");
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            this.__explicitlySet__.add("workingDirectory");
            return this;
        }

        public Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            this.__explicitlySet__.add("environmentVariables");
            return this;
        }

        public Builder volumeMounts(List<VolumeMount> volumeMounts) {
            this.volumeMounts = volumeMounts;
            this.__explicitlySet__.add("volumeMounts");
            return this;
        }

        public Builder healthChecks(List<ContainerHealthCheck> healthChecks) {
            this.healthChecks = healthChecks;
            this.__explicitlySet__.add("healthChecks");
            return this;
        }

        public Builder isResourcePrincipalDisabled(Boolean isResourcePrincipalDisabled) {
            this.isResourcePrincipalDisabled = isResourcePrincipalDisabled;
            this.__explicitlySet__.add("isResourcePrincipalDisabled");
            return this;
        }

        public Builder resourceConfig(ContainerResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            this.__explicitlySet__.add("resourceConfig");
            return this;
        }

        public Builder containerRestartAttemptCount(Integer containerRestartAttemptCount) {
            this.containerRestartAttemptCount = containerRestartAttemptCount;
            this.__explicitlySet__.add("containerRestartAttemptCount");
            return this;
        }

        public Container build() {
            Container model = new Container(this.id, this.displayName, this.compartmentId, this.freeformTags, this.definedTags, this.systemTags, this.availabilityDomain, this.faultDomain, this.lifecycleState, this.lifecycleDetails, this.exitCode, this.timeTerminated, this.timeCreated, this.timeUpdated, this.containerInstanceId, this.imageUrl, this.command, this.arguments, this.additionalCapabilities, this.workingDirectory, this.environmentVariables, this.volumeMounts, this.healthChecks, this.isResourcePrincipalDisabled, this.resourceConfig, this.containerRestartAttemptCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Container model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("exitCode")) {
                this.exitCode(model.getExitCode());
            }
            if (model.wasPropertyExplicitlySet("timeTerminated")) {
                this.timeTerminated(model.getTimeTerminated());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("containerInstanceId")) {
                this.containerInstanceId(model.getContainerInstanceId());
            }
            if (model.wasPropertyExplicitlySet("imageUrl")) {
                this.imageUrl(model.getImageUrl());
            }
            if (model.wasPropertyExplicitlySet("command")) {
                this.command(model.getCommand());
            }
            if (model.wasPropertyExplicitlySet("arguments")) {
                this.arguments(model.getArguments());
            }
            if (model.wasPropertyExplicitlySet("additionalCapabilities")) {
                this.additionalCapabilities(model.getAdditionalCapabilities());
            }
            if (model.wasPropertyExplicitlySet("workingDirectory")) {
                this.workingDirectory(model.getWorkingDirectory());
            }
            if (model.wasPropertyExplicitlySet("environmentVariables")) {
                this.environmentVariables(model.getEnvironmentVariables());
            }
            if (model.wasPropertyExplicitlySet("volumeMounts")) {
                this.volumeMounts(model.getVolumeMounts());
            }
            if (model.wasPropertyExplicitlySet("healthChecks")) {
                this.healthChecks(model.getHealthChecks());
            }
            if (model.wasPropertyExplicitlySet("isResourcePrincipalDisabled")) {
                this.isResourcePrincipalDisabled(model.getIsResourcePrincipalDisabled());
            }
            if (model.wasPropertyExplicitlySet("resourceConfig")) {
                this.resourceConfig(model.getResourceConfig());
            }
            if (model.wasPropertyExplicitlySet("containerRestartAttemptCount")) {
                this.containerRestartAttemptCount(model.getContainerRestartAttemptCount());
            }
            return this;
        }
    }
}

