/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.oracle.bmc.auth.ProvidesConfigurableRefresh;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.X509CertificateSupplier;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.OciCircuitBreaker;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpProvider;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.StandardClientProperties;
import com.oracle.bmc.http.internal.AuthnClientFilter;
import com.oracle.bmc.http.internal.CircuitBreakerHelper;
import com.oracle.bmc.http.internal.ClientCall;
import com.oracle.bmc.http.internal.ClientIdFilter;
import com.oracle.bmc.http.internal.LogHeadersFilter;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.KeySupplier;
import com.oracle.bmc.http.signing.internal.RequestSignerImpl;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.retrier.DefaultRetryCondition;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.VisibleForTesting;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.ExponentialBackoffDelayStrategyWithJitter;
import com.oracle.bmc.waiter.MaxAttemptsTerminationStrategy;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509FederationClient
implements FederationClient,
ProvidesConfigurableRefresh {
    private static final RetryConfiguration RETRY_CONFIGURATION = RetryConfiguration.builder().delayStrategy(new ExponentialBackoffDelayStrategyWithJitter(1000L)).terminationStrategy(new MaxAttemptsTerminationStrategy(3)).retryCondition(new DefaultRetryCondition(){

        @Override
        public boolean shouldBeRetried(@Nonnull BmcException e) {
            if (e == null) {
                throw new NullPointerException("e is marked non-null but is null");
            }
            return e.getStatusCode() < 400 || e.getStatusCode() >= 500;
        }
    }).build();
    private static final String DEFAULT_PURPOSE = "DEFAULT";
    private static final String DEFAULT_FINGERPRINT = "SHA256";
    private static final Logger LOG = LoggerFactory.getLogger(X509FederationClient.class);
    private final X509CertificateSupplier leafCertificateSupplier;
    private String tenancyId;
    private final Set<X509CertificateSupplier> intermediateCertificateSuppliers;
    private final SessionKeySupplier sessionKeySupplier;
    private final String purpose;
    private final HttpClient httpClient;
    private final ClientConfigurator clientConfigurator;
    private final List<ClientConfigurator> additionalClientConfigurators;
    private final OciCircuitBreaker circuitBreaker;
    private volatile SecurityTokenAdapter securityTokenAdapter = null;

    public X509FederationClient(String federationEndpoint, String tenancyId, X509CertificateSupplier leafCertificateSupplier, SessionKeySupplier sessionKeySupplier, Set<X509CertificateSupplier> intermediateCertificateSuppliers, ClientConfigurator clientConfigurator, List<ClientConfigurator> additionalClientConfigurators, CircuitBreakerConfiguration circuitBreakerConfig) {
        this(federationEndpoint, tenancyId, leafCertificateSupplier, sessionKeySupplier, intermediateCertificateSuppliers, clientConfigurator, additionalClientConfigurators, circuitBreakerConfig, DEFAULT_PURPOSE);
    }

    public X509FederationClient(String federationEndpoint, final String tenancyId, final X509CertificateSupplier leafCertificateSupplier, SessionKeySupplier sessionKeySupplier, Set<X509CertificateSupplier> intermediateCertificateSuppliers, ClientConfigurator clientConfigurator, List<ClientConfigurator> additionalClientConfigurators, CircuitBreakerConfiguration circuitBreakerConfig, String purpose) {
        this.leafCertificateSupplier = Validate.notNull(leafCertificateSupplier, "leafCertificateSupplier must not be null", new Object[0]);
        this.sessionKeySupplier = Validate.notNull(sessionKeySupplier, "sessionKeySupplier must not be null", new Object[0]);
        this.intermediateCertificateSuppliers = intermediateCertificateSuppliers;
        this.tenancyId = Validate.notNull(tenancyId, "tenancyId must not be null", new Object[0]);
        this.securityTokenAdapter = new SecurityTokenAdapter(null, sessionKeySupplier);
        this.purpose = Validate.notNull(purpose, "purpose must not be null", new Object[0]);
        this.clientConfigurator = clientConfigurator;
        this.additionalClientConfigurators = additionalClientConfigurators;
        KeySupplier<RSAPrivateKey> keySupplier = new KeySupplier<RSAPrivateKey>(){

            @Override
            @Nonnull
            public Optional<RSAPrivateKey> supplyKey(@Nonnull String keyId) {
                RSAPrivateKey privateKey = leafCertificateSupplier.getCertificateAndKeyPair().getPrivateKey();
                if (privateKey instanceof RSAPrivateKey) {
                    return Optional.of(privateKey);
                }
                throw new IllegalArgumentException("Private key was not an RSA private key: " + privateKey.getClass().getSimpleName());
            }
        };
        Supplier<String> keyIdSupplier = new Supplier<String>(){

            @Override
            public String get() {
                return X509FederationClient.keyIdForX509Request(tenancyId, leafCertificateSupplier.getCertificateAndKeyPair().getCertificate());
            }
        };
        this.httpClient = HttpProvider.getDefault().newBuilder().baseUri(URI.create(federationEndpoint)).property(StandardClientProperties.ASYNC_POOL_SIZE, (Object)1).registerRequestInterceptor(1000, (RequestInterceptor)new AuthnClientFilter(new RequestSignerImpl(keySupplier, SigningStrategy.STANDARD, keyIdSupplier), Collections.emptyMap())).registerRequestInterceptor(3000, (RequestInterceptor)new ClientIdFilter()).registerRequestInterceptor(5000, (RequestInterceptor)new LogHeadersFilter()).build();
        this.circuitBreaker = CircuitBreakerHelper.makeCircuitBreaker(this.httpClient, circuitBreakerConfig);
    }

    @Override
    public String getSecurityToken() {
        if (this.securityTokenAdapter.isValid()) {
            return this.securityTokenAdapter.getSecurityToken();
        }
        return this.refreshAndGetSecurityTokenInner(true, Optional.empty(), true);
    }

    @Override
    public String getStringClaim(String key) {
        this.refreshAndGetSecurityTokenInner(true, Optional.empty(), true);
        return this.securityTokenAdapter.getStringClaim(key);
    }

    @Override
    public String refreshAndGetSecurityToken() {
        return this.refreshAndGetSecurityTokenInner(false, Optional.empty(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String refreshAndGetSecurityTokenInner(boolean doFinalTokenValidityCheck, Optional<Duration> time, boolean refreshKeys) {
        X509FederationClient x509FederationClient = this;
        synchronized (x509FederationClient) {
            if (!doFinalTokenValidityCheck || (time.isPresent() ? !this.securityTokenAdapter.isValid(time) : !this.securityTokenAdapter.isValid())) {
                if (refreshKeys) {
                    LOG.info("Refreshing session keys.");
                    this.sessionKeySupplier.refreshKeys();
                }
                if (this.leafCertificateSupplier instanceof Refreshable) {
                    String newTenancyId;
                    try {
                        ((Refreshable)((Object)this.leafCertificateSupplier)).refresh();
                    }
                    catch (RefreshFailedException ex) {
                        throw new BmcException(false, "Can't refresh the leaf certification!", ex, null);
                    }
                    if (this.purpose.equals(DEFAULT_PURPOSE) && !this.tenancyId.equals(newTenancyId = AuthUtils.getTenantIdFromCertificate(this.leafCertificateSupplier.getCertificateAndKeyPair().getCertificate()))) {
                        throw new IllegalArgumentException("The tenancy id should never be changed in cert file!");
                    }
                }
                for (X509CertificateSupplier supplier : this.intermediateCertificateSuppliers) {
                    if (!(supplier instanceof Refreshable)) continue;
                    try {
                        ((Refreshable)((Object)supplier)).refresh();
                    }
                    catch (RefreshFailedException ex) {
                        throw new BmcException(false, "Can't refresh the intermediate certification!", ex, null);
                    }
                }
                this.securityTokenAdapter = this.getSecurityTokenFromServer();
                return this.securityTokenAdapter.getSecurityToken();
            }
            return this.securityTokenAdapter.getSecurityToken();
        }
    }

    private SecurityTokenAdapter getSecurityTokenFromServer() {
        LOG.info("Getting security token from the auth server");
        KeyPair keyPair = this.sessionKeySupplier.getKeyPair();
        if (keyPair == null) {
            throw new IllegalStateException("Keypair for session was not provided");
        }
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key is not present");
        }
        X509CertificateSupplier.CertificateAndPrivateKeyPair certificateAndKeyPair = this.leafCertificateSupplier.getCertificateAndKeyPair();
        if (certificateAndKeyPair == null) {
            throw new IllegalArgumentException("Certificate and key pair are not present");
        }
        X509Certificate leafCertificate = certificateAndKeyPair.getCertificate();
        if (leafCertificate == null) {
            throw new IllegalArgumentException("Leaf certificate is not present");
        }
        if (certificateAndKeyPair.getPrivateKey() == null) {
            throw new IllegalArgumentException("Leaf certificate's private key is not present");
        }
        try {
            HashSet<String> intermediateStrings = null;
            if (this.intermediateCertificateSuppliers != null && this.intermediateCertificateSuppliers.size() > 0) {
                LOG.debug("Intermediate certificate(s) were supplied");
                intermediateStrings = new HashSet<String>();
                for (X509CertificateSupplier supplier : this.intermediateCertificateSuppliers) {
                    X509CertificateSupplier.CertificateAndPrivateKeyPair supplierCertificateAndKeyPair = supplier.getCertificateAndKeyPair();
                    if (supplierCertificateAndKeyPair == null || supplierCertificateAndKeyPair.getCertificate() == null) continue;
                    intermediateStrings.add(AuthUtils.base64EncodeNoChunking(supplierCertificateAndKeyPair.getCertificate()));
                }
            }
            X509FederationRequest federationRequest = new X509FederationRequest(AuthUtils.base64EncodeNoChunking(publicKey), AuthUtils.base64EncodeNoChunking(leafCertificate), intermediateStrings, this.purpose, DEFAULT_FINGERPRINT);
            FederationResponseWrapper resp = this.makeCall(federationRequest);
            return new SecurityTokenAdapter(resp.token.getToken(), this.sessionKeySupplier);
        }
        catch (BmcException e) {
            throw e;
        }
        catch (CertificateException e) {
            LOG.info("Failed to get encoded x509 certificate");
            throw new IllegalArgumentException("Failed to get encoded x509 certificate", e);
        }
    }

    @VisibleForTesting
    FederationResponseWrapper makeCall(X509FederationRequest federationRequest) {
        return (FederationResponseWrapper)ClientCall.builder(this.httpClient, new FederationRequestWrapper(federationRequest), FederationResponseWrapper.Builder::new).method(Method.POST).logger(LOG, "X509FederationClient").appendPathPart("v1").appendPathPart("x509").handleBody(SecurityToken.class, (builder, token) -> {
            builder.token = token;
        }).retryConfiguration(RETRY_CONFIGURATION).clientConfigurator(this.clientConfigurator).circuitBreaker(this.circuitBreaker).accept("*/*").hasBody().callSync();
    }

    @Override
    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time) {
        return this.refreshAndGetSecurityTokenInner(true, Optional.of(time), true);
    }

    @Override
    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time, boolean refreshKeys) {
        return this.refreshAndGetSecurityTokenInner(true, Optional.of(time), refreshKeys);
    }

    public X509CertificateSupplier getLeafCertificateSupplier() {
        return this.leafCertificateSupplier;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    private static String keyIdForX509Request(String tenancyId, X509Certificate certificate) {
        return String.format("%s/fed-x509-sha256/%s", tenancyId, AuthUtils.getFingerPrint(certificate));
    }

    public static class FederationResponseWrapper
    extends BmcResponse {
        final SecurityToken token;

        FederationResponseWrapper(int status, SecurityToken token) {
            super(status);
            this.token = token;
        }

        public SecurityToken getToken() {
            return this.token;
        }

        public static class Builder
        implements BmcResponse.Builder<FederationResponseWrapper> {
            private int status;
            private Map<String, List<String>> headers;
            SecurityToken token;

            public Builder() {
            }

            private Builder(FederationResponseWrapper b) {
                this.status = b.get__httpStatusCode__();
                this.token = b.token;
            }

            @Override
            public BmcResponse.Builder<FederationResponseWrapper> __httpStatusCode__(int __httpStatusCode__) {
                this.status = __httpStatusCode__;
                return this;
            }

            @Override
            public BmcResponse.Builder<FederationResponseWrapper> headers(Map<String, List<String>> headers) {
                this.headers = headers;
                return this;
            }

            @Override
            public BmcResponse.Builder<FederationResponseWrapper> copy(FederationResponseWrapper o) {
                return new Builder(o);
            }

            @Override
            public FederationResponseWrapper build() {
                return new FederationResponseWrapper(this.status, this.token);
            }

            public SecurityToken getToken() {
                return this.token;
            }

            public void setToken(SecurityToken token) {
                this.token = token;
            }
        }
    }

    private static class FederationRequestWrapper
    extends BmcRequest<X509FederationRequest> {
        private final X509FederationRequest request;

        FederationRequestWrapper(X509FederationRequest request) {
            this.request = request;
        }

        @Override
        public X509FederationRequest getBody$() {
            return this.request;
        }
    }

    public static class SecurityToken {
        private String token;

        public SecurityToken(@JsonProperty(value="token") String token) {
            this.token = token;
        }

        public String getToken() {
            return this.token;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class X509FederationRequest {
        private final Set<String> intermediateCertificates;
        private final String certificate;
        private final String publicKey;
        private final String purpose;
        private final String fingerprintAlgorithm;

        public X509FederationRequest(String publicKey, String certificate, Set<String> intermediateCertificates, String purpose, String fingerprintAlgorithm) {
            this.certificate = Validate.notNull(certificate, "certificate must not be null", new Object[0]);
            this.publicKey = Validate.notNull(publicKey, "publicKey must not be null", new Object[0]);
            this.intermediateCertificates = intermediateCertificates;
            this.purpose = purpose;
            this.fingerprintAlgorithm = fingerprintAlgorithm;
        }

        public Set<String> getIntermediateCertificates() {
            return this.intermediateCertificates;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getPurpose() {
            return this.purpose;
        }

        public String getFingerprintAlgorithm() {
            return this.fingerprintAlgorithm;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof X509FederationRequest)) {
                return false;
            }
            X509FederationRequest other = (X509FederationRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$intermediateCertificates = this.getIntermediateCertificates();
            Set<String> other$intermediateCertificates = other.getIntermediateCertificates();
            if (this$intermediateCertificates == null ? other$intermediateCertificates != null : !((Object)this$intermediateCertificates).equals(other$intermediateCertificates)) {
                return false;
            }
            String this$certificate = this.getCertificate();
            String other$certificate = other.getCertificate();
            if (this$certificate == null ? other$certificate != null : !this$certificate.equals(other$certificate)) {
                return false;
            }
            String this$publicKey = this.getPublicKey();
            String other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            String this$purpose = this.getPurpose();
            String other$purpose = other.getPurpose();
            if (this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose)) {
                return false;
            }
            String this$fingerprintAlgorithm = this.getFingerprintAlgorithm();
            String other$fingerprintAlgorithm = other.getFingerprintAlgorithm();
            return !(this$fingerprintAlgorithm == null ? other$fingerprintAlgorithm != null : !this$fingerprintAlgorithm.equals(other$fingerprintAlgorithm));
        }

        protected boolean canEqual(Object other) {
            return other instanceof X509FederationRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $intermediateCertificates = this.getIntermediateCertificates();
            result = result * 59 + ($intermediateCertificates == null ? 43 : ((Object)$intermediateCertificates).hashCode());
            String $certificate = this.getCertificate();
            result = result * 59 + ($certificate == null ? 43 : $certificate.hashCode());
            String $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            String $purpose = this.getPurpose();
            result = result * 59 + ($purpose == null ? 43 : $purpose.hashCode());
            String $fingerprintAlgorithm = this.getFingerprintAlgorithm();
            result = result * 59 + ($fingerprintAlgorithm == null ? 43 : $fingerprintAlgorithm.hashCode());
            return result;
        }
    }
}

