/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RefreshAuthTokenWrapper<REQUEST extends BmcRequest<?>, RESPONSE>
implements AsyncHandler<REQUEST, RESPONSE>,
Future<RESPONSE> {
    private static final int NUM_TRIES_ALLOWED = 2;
    private static final Logger LOG = LoggerFactory.getLogger(RefreshAuthTokenWrapper.class);
    private final RefreshableOnNotAuthenticatedProvider<?> authDetailsProvider;
    private final AsyncHandler<REQUEST, RESPONSE> innerHandler;
    private final Function<AsyncHandler<REQUEST, RESPONSE>, Future<RESPONSE>> futureSupplier;
    @Nonnull
    private Future<RESPONSE> delegate;
    private volatile int currentAttempt = 0;

    public RefreshAuthTokenWrapper(RefreshableOnNotAuthenticatedProvider<?> authDetailsProvider, AsyncHandler<REQUEST, RESPONSE> innerHandler, Function<AsyncHandler<REQUEST, RESPONSE>, Future<RESPONSE>> futureSupplier) {
        this.authDetailsProvider = authDetailsProvider;
        this.innerHandler = innerHandler;
        this.futureSupplier = futureSupplier;
        this.delegate = this.buildResponseFuture();
    }

    @Override
    public void onSuccess(REQUEST request, RESPONSE response) {
        this.innerHandler.onSuccess(request, response);
    }

    @Override
    public void onError(REQUEST request, Throwable error) {
        if (error instanceof BmcException) {
            if (((BmcException)error).getStatusCode() == 401) {
                if (!this.retryCall()) {
                    this.innerHandler.onError(request, error);
                }
            } else {
                this.innerHandler.onError(request, error);
            }
        } else {
            this.innerHandler.onError(request, error);
        }
    }

    public synchronized boolean retryCall() {
        if (!this.delegate.isDone()) {
            return true;
        }
        ++this.currentAttempt;
        if (this.currentAttempt >= 2) {
            return false;
        }
        this.authDetailsProvider.refresh();
        this.beforeRetryAction();
        this.delegate = this.buildResponseFuture();
        return true;
    }

    protected abstract void beforeRetryAction();

    protected Future<RESPONSE> buildResponseFuture() {
        return this.futureSupplier.apply(this);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public RESPONSE get() throws InterruptedException, ExecutionException {
        try {
            return this.delegate.get();
        }
        catch (BmcException e) {
            if (e.getStatusCode() == 401) {
                this.retryCall();
                return this.delegate.get();
            }
            throw e;
        }
    }

    @Override
    public RESPONSE get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.delegate.get(timeout, unit);
        }
        catch (BmcException e) {
            if (e.getStatusCode() == 401) {
                this.retryCall();
                return this.delegate.get(timeout, unit);
            }
            throw e;
        }
    }
}

