/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.http.client.internal.RFC3339DateFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpDateUtils.class);
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");
    private static final Date AMBIGUOUS_YEAR_TWO_DIGIT_YEAR_START;
    private static final ThreadLocal<List<DateFormat>> RFC2616_DATE_FORMATS;
    private static final ThreadLocal<List<DateFormat>> RFC3339_DATE_FORMATS;

    private static List<DateFormat> createRfc2616DateFormats() {
        ArrayList<DateFormat> dateFormats = new ArrayList<DateFormat>();
        dateFormats.add(new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US));
        SimpleDateFormat rfc1036Format = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
        rfc1036Format.set2DigitYearStart(AMBIGUOUS_YEAR_TWO_DIGIT_YEAR_START);
        dateFormats.add(rfc1036Format);
        dateFormats.add(new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US));
        HttpDateUtils.init(dateFormats);
        return dateFormats;
    }

    private static void init(List<DateFormat> formats) {
        for (DateFormat format : formats) {
            format.setTimeZone(TIMEZONE_GMT);
        }
    }

    static Date parse(String headerName, String value) {
        String lowerCasedHeaderName = headerName.toLowerCase(Locale.ROOT);
        if ("date".equals(lowerCasedHeaderName) || "last-modified".equals(lowerCasedHeaderName)) {
            Date date = HttpDateUtils.tryParse(value, RFC2616_DATE_FORMATS.get());
            if (date == null) {
                LOG.warn("Could not create Date instance from rfc2616 format: " + value);
            }
            return date;
        }
        Date date = HttpDateUtils.tryParse(value, RFC3339_DATE_FORMATS.get());
        if (date == null) {
            LOG.warn("Could not create Date instance from rfc3339 format: " + value);
        }
        return date;
    }

    public static String format(Date date) {
        boolean includeMillis = date.getTime() % 1000L != 0L;
        return RFC3339DateFormat.formatRfc3339((Date)date, (boolean)includeMillis);
    }

    private static Date tryParse(String date, List<DateFormat> formats) {
        for (DateFormat format : formats) {
            try {
                Date result = format.parse(date);
                format.setTimeZone(TIMEZONE_GMT);
                return result;
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    static {
        RFC2616_DATE_FORMATS = new ThreadLocal<List<DateFormat>>(){

            @Override
            protected synchronized List<DateFormat> initialValue() {
                return HttpDateUtils.createRfc2616DateFormats();
            }
        };
        RFC3339_DATE_FORMATS = new ThreadLocal<List<DateFormat>>(){

            @Override
            protected List<DateFormat> initialValue() {
                RFC3339DateFormat format = new RFC3339DateFormat();
                return Collections.singletonList(format);
            }
        };
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TIMEZONE_GMT);
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        AMBIGUOUS_YEAR_TWO_DIGIT_YEAR_START = calendar.getTime();
    }
}

