/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.oracle.bmc.util.internal.Validate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JWK {
    private static final String KEY_TYPE = "RSA";
    private static final String USE = "sig";
    private static final String ALGORITHM = "RS256";
    private final String n;
    private final String e;
    private final String kid;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String use;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String algorithm;

    public JWK(@Nonnull String kid, @Nonnull String n, @Nonnull String e) {
        this(kid, n, e, KEY_TYPE, ALGORITHM, USE);
    }

    @JsonCreator
    public JWK(@JsonProperty(value="kid") @Nonnull String kid, @JsonProperty(value="n") @Nonnull String n, @JsonProperty(value="e") @Nonnull String e, @JsonProperty(value="kty") @Nonnull String type, @JsonProperty(value="alg") @Nonnull String algorithm, @JsonProperty(value="use") @Nullable String use) {
        Validate.notBlank(kid, "kid may not be blank", new Object[0]);
        Validate.notBlank(n, "n may not be blank", new Object[0]);
        Validate.notBlank(e, "e may not be blank", new Object[0]);
        Validate.isTrue(type.trim().equals(KEY_TYPE), "type must equal 'RSA'", new Object[0]);
        this.n = n;
        this.e = e;
        this.kid = kid;
        this.algorithm = algorithm;
        this.use = use;
    }

    @JsonProperty(value="kty")
    public String getKeyType() {
        return KEY_TYPE;
    }

    @JsonProperty(value="use")
    public String getPublicKeyUse() {
        return this.use;
    }

    @JsonProperty(value="alg")
    public String getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="kid")
    public String getKeyId() {
        return this.kid;
    }

    @JsonProperty(value="n")
    public String getModulus() {
        return this.n;
    }

    @JsonProperty(value="e")
    public String getPublicExponent() {
        return this.e;
    }
}

