/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ApacheConnectorProperties;
import com.oracle.bmc.http.ApacheConnectorPropertiesClientConfigDecorator;
import com.oracle.bmc.http.ClientConfigDecorator;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.HasApacheConnectorProperties;
import com.oracle.bmc.http.SetsClientBuilderProperties;
import com.oracle.bmc.http.internal.ContentLengthFilter;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.JavaRuntimeUtils;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import lombok.NonNull;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheConfigurator
implements ClientConfigurator,
SetsClientBuilderProperties,
HasApacheConnectorProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheConfigurator.class);
    protected final List<ClientConfigDecorator> clientConfigDecorators = new LinkedList<ClientConfigDecorator>();
    protected ApacheConnectorProperties apacheConnectorProperties;

    public ApacheConfigurator() {
        this.apacheConnectorProperties = ApacheConnectorProperties.builder().build();
    }

    public ApacheConfigurator(List<ClientConfigDecorator> clientConfigDecorators) {
        this.apacheConnectorProperties = ApacheConnectorProperties.builder().build();
        this.clientConfigDecorators.addAll(clientConfigDecorators);
    }

    public ApacheConfigurator(@NonNull ApacheConnectorProperties apacheConnectorProperties) {
        if (apacheConnectorProperties == null) {
            throw new NullPointerException("apacheConnectorProperties is marked non-null but is null");
        }
        this.apacheConnectorProperties = apacheConnectorProperties;
    }

    public ApacheConfigurator(@NonNull ApacheConnectorProperties apacheConnectorProperties, List<ClientConfigDecorator> clientConfigDecorators) {
        if (apacheConnectorProperties == null) {
            throw new NullPointerException("apacheConnectorProperties is marked non-null but is null");
        }
        this.apacheConnectorProperties = apacheConnectorProperties;
        this.clientConfigDecorators.addAll(clientConfigDecorators);
    }

    @Override
    public void customizeBuilder(ClientBuilder builder) {
        this.setConnectorProvider(builder);
        this.setSslContext(builder);
    }

    @Override
    public void customizeClient(Client client) {
        client.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        client.register((Object)new ContentLengthFilter());
    }

    @Override
    public void setConnectorProvider(ClientBuilder builder) {
        LOG.info("Setting connector provider to ApacheConnectorProvider");
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        if (this.apacheConnectorProperties != null) {
            ApacheConnectorPropertiesClientConfigDecorator defaultClientConfig = new ApacheConnectorPropertiesClientConfigDecorator(this.apacheConnectorProperties);
            defaultClientConfig.customizeClientConfig(clientConfig);
        }
        for (ClientConfigDecorator clientConfigDecorator : this.clientConfigDecorators) {
            clientConfigDecorator.customizeClientConfig(clientConfig);
        }
        builder.withConfig((Configuration)clientConfig);
    }

    @Override
    public void setSslContext(ClientBuilder builder) {
        JavaRuntimeUtils.JreVersion version = JavaRuntimeUtils.getRuntimeVersion();
        if (version == JavaRuntimeUtils.JreVersion.Java_7) {
            LOG.info("Running on 1.7 VM, manually setting security protocol to TLSv1.2");
            SSLContext sslContext = SslConfigurator.newInstance((boolean)true).securityProtocol("TLSv1.2").createSSLContext();
            builder.sslContext(sslContext);
        } else if (version == JavaRuntimeUtils.JreVersion.Unsupported) {
            LOG.error("Using an unsupported runtime only 1.7+ is supported");
        } else if (version == JavaRuntimeUtils.JreVersion.Unknown) {
            LOG.warn("Using an unknown runtime, calls may not work");
        }
    }

    @Override
    public void customizeRequest(BmcRequest<?> request, WrappedInvocationBuilder ib) {
        if (this.apacheConnectorProperties == null || !this.apacheConnectorProperties.isExpectContinue()) {
            LOG.trace("Not adding Expect: 100-Continue, not enabled");
            return;
        }
        if (!request.supportsExpect100Continue()) {
            LOG.trace("Not adding Expect: 100-Continue, not supported by operation per {}", (Object)request.getClass().getName());
            return;
        }
        if (request.getBody$() != null) {
            if (ib.getHeaders().get((Object)"Expect") == null) {
                LOG.trace("Adding Expect: 100-Continue, request {} has a body", (Object)request.getClass().getName());
                ib.header("Expect", "100-continue");
            } else {
                LOG.trace("Not adding Expect: 100-Continue, request {} has header {} set to {}", new Object[]{request.getClass().getName(), "Expect", ib.getHeaders().get((Object)"Expect")});
            }
        } else {
            LOG.trace("Not adding Expect: 100-Continue, request {} has no body", (Object)request.getClass().getName());
        }
    }

    @Override
    public ApacheConnectorProperties getApacheConnectorProperties() {
        return this.apacheConnectorProperties;
    }

    public static class NonBuffering
    extends ApacheConfigurator
    implements HasApacheConnectorProperties {
        public NonBuffering() {
        }

        public NonBuffering(List<ClientConfigDecorator> clientConfigDecorators) {
            this.apacheConnectorProperties = ApacheConnectorProperties.builder().build();
            this.clientConfigDecorators.addAll(clientConfigDecorators);
        }

        public NonBuffering(@NonNull ApacheConnectorProperties apacheConnectorProperties) {
            if (apacheConnectorProperties == null) {
                throw new NullPointerException("apacheConnectorProperties is marked non-null but is null");
            }
            this.apacheConnectorProperties = apacheConnectorProperties;
        }

        public NonBuffering(@NonNull ApacheConnectorProperties apacheConnectorProperties, List<ClientConfigDecorator> clientConfigDecorators) {
            if (apacheConnectorProperties == null) {
                throw new NullPointerException("apacheConnectorProperties is marked non-null but is null");
            }
            this.apacheConnectorProperties = apacheConnectorProperties;
            this.clientConfigDecorators.addAll(clientConfigDecorators);
        }

        @Override
        public void customizeClient(Client client) {
            super.customizeClient(client);
        }

        @Override
        public void setConnectorProvider(ClientBuilder builder) {
            super.setConnectorProvider(builder);
        }
    }
}

