/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.oracle.bmc.retrier.DefaultRetryCondition;
import com.oracle.bmc.retrier.RetryCondition;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.ExponentialBackoffDelayStrategy;
import com.oracle.bmc.waiter.MaxAttemptsTerminationStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.WaiterConfiguration;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class RetryConfiguration
extends WaiterConfiguration {
    static final RetryConfiguration NO_RETRY_CONFIGURATION = RetryConfiguration.builder().build();
    private final RetryCondition retryCondition;

    private RetryConfiguration(@NonNull TerminationStrategy terminationStrategy, @NonNull DelayStrategy delayStrategy, @NonNull RetryCondition retryCondition) {
        super(terminationStrategy, delayStrategy);
        if (terminationStrategy == null) {
            throw new NullPointerException("terminationStrategy is marked @NonNull but is null");
        }
        if (delayStrategy == null) {
            throw new NullPointerException("delayStrategy is marked @NonNull but is null");
        }
        if (retryCondition == null) {
            throw new NullPointerException("retryCondition is marked @NonNull but is null");
        }
        this.retryCondition = retryCondition;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "RetryConfiguration(super=" + super.toString() + ", retryCondition=" + this.getRetryCondition() + ")";
    }

    public RetryCondition getRetryCondition() {
        return this.retryCondition;
    }

    public static class Builder {
        private static final TerminationStrategy NO_RETRY_TERMINATION_STRATEGY = new MaxAttemptsTerminationStrategy(1);
        private static final DelayStrategy EXPONENTIAL_BACKOFF_DELAY_STRATEGY = new ExponentialBackoffDelayStrategy(TimeUnit.SECONDS.toMillis(30L));
        private TerminationStrategy terminationStrategy = NO_RETRY_TERMINATION_STRATEGY;
        private DelayStrategy delayStrategy = EXPONENTIAL_BACKOFF_DELAY_STRATEGY;
        private RetryCondition retryCondition = new DefaultRetryCondition();

        public Builder terminationStrategy(@NonNull TerminationStrategy terminationStrategy) {
            if (terminationStrategy == null) {
                throw new NullPointerException("terminationStrategy is marked @NonNull but is null");
            }
            this.terminationStrategy = terminationStrategy;
            return this;
        }

        public Builder delayStrategy(@NonNull DelayStrategy delayStrategy) {
            if (delayStrategy == null) {
                throw new NullPointerException("delayStrategy is marked @NonNull but is null");
            }
            this.delayStrategy = delayStrategy;
            return this;
        }

        public Builder retryCondition(@NonNull RetryCondition retryCondition) {
            if (retryCondition == null) {
                throw new NullPointerException("retryCondition is marked @NonNull but is null");
            }
            this.retryCondition = retryCondition;
            return this;
        }

        public RetryConfiguration build() {
            return new RetryConfiguration(this.terminationStrategy, this.delayStrategy, this.retryCondition);
        }
    }
}

